% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launchers.R
\name{remote_config}
\alias{remote_config}
\alias{ssh_config}
\title{Generic and SSH Remote Launch Configuration}
\usage{
remote_config(command = NULL, args = c("", "."), rscript = "Rscript")

ssh_config(
  remotes,
  timeout = 5,
  tunnel = FALSE,
  command = "ssh",
  rscript = "Rscript"
)
}
\arguments{
\item{command}{the command used to effect the daemon launch on the remote
machine as a character string (e.g. \code{'ssh'}). Defaults to 'ssh' for
\code{ssh_config}, although may be substituted for the full path to a
specific SSH application. The default NULL for \code{remote_config} does
not effect any launches, but causes \code{\link{launch_remote}} to return
the shell commands for manual deployment on remote machines.}

\item{args}{(optional) arguments passed to 'command', as a character vector
that must include \code{"."} as an element, which will be substituted
for the daemon launch command. Alternatively, a list of such character
vectors to effect multiple launches (one for each list element).}

\item{rscript}{(optional) name / path of the Rscript executable on the remote
machine. The default assumes 'Rscript' is on the executable search path.
Prepend the full path if necessary. If launching on Windows, 'Rscript'
should be replaced with 'Rscript.exe'.}

\item{remotes}{the character URL or vector of URLs to SSH into, using the
'ssh://' scheme and including the port open for SSH connections (defaults
to 22 if not specified), e.g. 'ssh://10.75.32.90:22' or 'ssh://nodename'.}

\item{timeout}{[default 5] maximum time allowed for connection setup in seconds.}

\item{tunnel}{[default FALSE] logical value whether to use SSH reverse
tunnelling. If TRUE, a tunnel is created between the same ports (as
specified in 'url') on the local and remote machines. Setting to TRUE
requires access to 'url' in the evaluation context and will error if not
called from a relevant function.}
}
\value{
A list in the required format to be supplied to the 'remote' argument
    of \code{\link{launch_remote}}, \code{\link{daemons}}, or \code{\link{make_cluster}}.
}
\description{
\code{remote_config} provides a flexible generic framework for generating
    the shell commands to deploy daemons remotely.

\code{ssh_config} generates a remote configuration for launching daemons over
    SSH, with the option of SSH tunnelling.
}
\section{SSH Direct Connections}{


    The simplest use of SSH is to execute the daemon launch command on a
    remote machine, for it to dial back to the host / dispatcher URL.

    It is assumed that SSH key-based authentication is already in place. The
    relevant port on the host must also be open to inbound connections from
    the remote machine.
}

\section{SSH Tunnelling}{


    Use of SSH tunnelling provides a convenient way to launch remote nodes
    without requiring the remote machine to be able to access the host.
    Often firewall configurations or security policies may prevent opening a
    port to accept outside connections.

    In these cases SSH tunnelling offers a solution by creating a tunnel once
    the initial SSH connection is made. For simplicity, this SSH tunnelling
    implementation uses the same port on both the side of the host and that
    of the corresponding node. SSH key-based authentication must also already
    be in place.

    Tunnelling requires the hostname for 'url' specified when setting up
    \code{\link{daemons}} to be either '127.0.0.1' or 'localhost'. This is as
    the tunnel is created between \code{127.0.0.1:port} or equivalently
    \code{localhost:port} on each machine. The host listens to \code{port} on
    its machine and the remotes each dial into \code{port} on their own
    respective machines.
}

\examples{
remote_config(command = "ssh", args = c("-fTp 22 10.75.32.90", "."))

ssh_config(remotes = c("ssh://10.75.32.90:222", "ssh://nodename"), timeout = 10)

\dontrun{

# launch 2 daemons on the remote machines 10.75.32.90 and 10.75.32.91 using
# SSH, connecting back directly to the host URL over a TLS connection:

daemons(
  url = host_url(tls = TRUE),
  remote = ssh_config(
    remotes = c("ssh://10.75.32.90:222", "ssh://10.75.32.91:222"),
    timeout = 1
  )
)

# launch 2 nodes on the remote machine 10.75.32.90 using SSH tunnelling over
# port 5555 ('url' hostname must be 'localhost' or '127.0.0.1'):

cl <- make_cluster(
  url = "tcp://localhost:5555",
  remote = ssh_config(
    remotes = c("ssh://10.75.32.90", "ssh://10.75.32.90"),
    timeout = 1,
    tunnel = TRUE
  )
)
}

}
