% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autographr.R
\name{autographr}
\alias{autographr}
\title{Quickly graph networks with sensible defaults}
\usage{
autographr(
  object,
  layout = "stress",
  labels = TRUE,
  node_color = NULL,
  node_group = NULL,
  node_shape = NULL,
  node_size = NULL,
  ...
)
}
\arguments{
\item{object}{A migraph-consistent object.}

\item{layout}{An igraph layout algorithm,
currently defaults to 'stress'.}

\item{labels}{Logical, whether to print node names
as labels if present.}

\item{node_color}{Node variable in quotation marks to be used for
colouring the nodes.}

\item{node_group}{Node variable in quotation marks to be used for
drawing convex but also concave hulls around clusters of nodes.
These groupings will be labelled with the categories of the variable passed.}

\item{node_shape}{Node variable in quotation marks to be used for
the shapes of the nodes.
Shapes will be follow the ordering "circle", "square", "triangle",
so this aesthetic should be used for a variable with only a few categories.}

\item{node_size}{Node variable in quotation marks to be used for
the size of the nodes.
This can be any continuous variable on the nodes of the network.
Since this function expects this to be an existing variable,
it is recommended to calculate all node-related statistics prior
to using this function.}

\item{...}{Extra arguments.}
}
\description{
The aim of this function is to provide users with a quick and easy
graphing function that makes best use of the data,
whatever its composition.
}
\examples{
autographr(ison_coleman)
autographr(ison_karateka)
}
