% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaaGenerics.R, R/objectSetOfSchemes.R,
%   R/objectSetOfTimePoints.R
\docType{methods}
\name{extractByRank}
\alias{extractByRank}
\alias{extractByRank,SetOfSchemes,numeric-method}
\alias{extractByRank,SetOfTimePoints,numeric-method}
\title{extract a timepoint or Scheme choice by its rank}
\usage{
extractByRank(object, rank)

\S4method{extractByRank}{SetOfSchemes,numeric}(object, rank)

\S4method{extractByRank}{SetOfTimePoints,numeric}(object, rank)
}
\arguments{
\item{object}{an S4 object}

\item{rank}{integer}
}
\description{
extract a timepoint or Scheme choice by its rank
}
\examples{
  object        <-  getExampleSetOfSchemes()
  pkData        <-  getPkData( getExamplePkModel() , 
   getTimePoints( object ) , getNSubjects( object ) , nSamples = 10  )
  objectRanked    <- rankObject(  object ,  pkData  ,
    data.frame(criterion = "auc" , weight = 1 , stringsAsFactors = TRUE) ) 
 extractByRank( object = objectRanked  , rank = 1 )
 extractByRank( objectRanked  , rank = 5 )
  object                             <-  getExampleSetOfTimePoints( 0 :10 ) 
  pkData                             <-  getPkData(getExamplePkModel() ,
 getTimePoints( object ) , 1 , 5 )
objectRanked                       <-  rankObject( object , pkData , nGrid = 20,
  nSamplesAvCurve = 25 )
  extractByRank( objectRanked , 1)
  extractByRank( object = objectRanked , rank = 5 )
}
