% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_env.R
\name{trans_env}
\alias{trans_env}
\title{Create \code{trans_env} object to analyze the association between environmental factor and microbial community.}
\description{
This class is a wrapper for a series of operations associated with environmental measurements, including redundancy analysis, 
mantel test, correlation analysis and linear fitting.
}
\examples{

## ------------------------------------------------
## Method `trans_env$new`
## ------------------------------------------------

data(dataset)
data(env_data_16S)
t1 <- trans_env$new(dataset = dataset, add_data = env_data_16S[, 4:11])

## ------------------------------------------------
## Method `trans_env$cal_diff`
## ------------------------------------------------

\donttest{
t1$cal_diff(group = "Group", method = "KW")
t1$cal_diff(group = "Group", method = "anova")
}

## ------------------------------------------------
## Method `trans_env$cal_autocor`
## ------------------------------------------------

\dontrun{
# Spearman correlation
t1$cal_autocor(upper = list(continuous = GGally::wrap("cor", method= "spearman")))
}

## ------------------------------------------------
## Method `trans_env$cal_ordination`
## ------------------------------------------------

\donttest{
t1$cal_ordination(method = "dbRDA", use_measure = "bray")
t1$cal_ordination(method = "RDA", taxa_level = "Genus")
t1$cal_ordination(method = "CCA", taxa_level = "Genus")
}

## ------------------------------------------------
## Method `trans_env$cal_ordination_anova`
## ------------------------------------------------

\donttest{
t1$cal_ordination_anova()
}

## ------------------------------------------------
## Method `trans_env$cal_ordination_envfit`
## ------------------------------------------------

\donttest{
t1$cal_ordination_envfit()
}

## ------------------------------------------------
## Method `trans_env$trans_ordination`
## ------------------------------------------------

\donttest{
t1$trans_ordination(adjust_arrow_length = TRUE, min_perc_env = 0.1, max_perc_env = 1)
}

## ------------------------------------------------
## Method `trans_env$plot_ordination`
## ------------------------------------------------

\donttest{
t1$cal_ordination(method = "RDA")
t1$trans_ordination(adjust_arrow_length = TRUE, max_perc_env = 1.5)
t1$plot_ordination(plot_color = "Group")
t1$plot_ordination(plot_color = "Group", plot_shape = "Group", plot_type = c("point", "ellipse"))
t1$plot_ordination(plot_color = "Group", plot_type = c("point", "chull"))
t1$plot_ordination(plot_color = "Group", plot_type = c("point", "centroid"), 
	  centroid_segment_linetype = 1)
t1$plot_ordination(plot_color = "Group", env_nudge_x = c(0.4, 0, 0, 0, 0, -0.2, 0, 0), 
	  env_nudge_y = c(0.6, 0, 0.2, 0.5, 0, 0.1, 0, 0.2))
}

## ------------------------------------------------
## Method `trans_env$cal_mantel`
## ------------------------------------------------

\donttest{
t1$cal_mantel(use_measure = "bray")
t1$cal_mantel(partial_mantel = TRUE, use_measure = "bray")
}

## ------------------------------------------------
## Method `trans_env$cal_cor`
## ------------------------------------------------

\donttest{
t2 <- trans_diff$new(dataset = dataset, method = "rf", group = "Group", rf_taxa_level = "Genus")
t1 <- trans_env$new(dataset = dataset, add_data = env_data_16S[, 4:11])
t1$cal_cor(use_data = "other", p_adjust_method = "fdr", other_taxa = t2$res_diff$Taxa[1:40])
}

## ------------------------------------------------
## Method `trans_env$plot_cor`
## ------------------------------------------------

\donttest{
t1$plot_cor(pheatmap = FALSE)
}

## ------------------------------------------------
## Method `trans_env$plot_scatterfit`
## ------------------------------------------------

\donttest{
t1$plot_scatterfit(x = 1, y = 2, type = "cor")
t1$plot_scatterfit(x = 1, y = 2, type = "lm", point_alpha = .3)
t1$plot_scatterfit(x = "pH", y = "TOC", type = "lm", group = "Group", line_se = FALSE)
t1$plot_scatterfit(x = 
	 dataset$beta_diversity$bray[rownames(t1$data_env), rownames(t1$data_env)], y = "pH")
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-trans_env-new}{\code{trans_env$new()}}
\item \href{#method-trans_env-cal_diff}{\code{trans_env$cal_diff()}}
\item \href{#method-trans_env-plot_diff}{\code{trans_env$plot_diff()}}
\item \href{#method-trans_env-cal_autocor}{\code{trans_env$cal_autocor()}}
\item \href{#method-trans_env-cal_ordination}{\code{trans_env$cal_ordination()}}
\item \href{#method-trans_env-cal_ordination_anova}{\code{trans_env$cal_ordination_anova()}}
\item \href{#method-trans_env-cal_ordination_envfit}{\code{trans_env$cal_ordination_envfit()}}
\item \href{#method-trans_env-trans_ordination}{\code{trans_env$trans_ordination()}}
\item \href{#method-trans_env-plot_ordination}{\code{trans_env$plot_ordination()}}
\item \href{#method-trans_env-cal_mantel}{\code{trans_env$cal_mantel()}}
\item \href{#method-trans_env-cal_cor}{\code{trans_env$cal_cor()}}
\item \href{#method-trans_env-plot_cor}{\code{trans_env$plot_cor()}}
\item \href{#method-trans_env-plot_scatterfit}{\code{trans_env$plot_scatterfit()}}
\item \href{#method-trans_env-print}{\code{trans_env$print()}}
\item \href{#method-trans_env-clone}{\code{trans_env$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_env-new"></a>}}
\if{latex}{\out{\hypertarget{method-trans_env-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$new(
  dataset = NULL,
  env_cols = NULL,
  add_data = NULL,
  character2numeric = FALSE,
  standardize = FALSE,
  complete_na = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the object of \code{\link{microtable}} Class.}

\item{\code{env_cols}}{default NULL; either numeric vector or character vector to select columns in \code{microtable$sample_table}, i.e. dataset$sample_table. 
This parameter should be used in the case that all the required environmental data is in \code{sample_table} of your \code{microtable} object.
Otherwise, please use \code{add_data} parameter.}

\item{\code{add_data}}{default NULL; \code{data.frame} format; provide the environmental data in the format \code{data.frame}; rownames should be sample names.
This parameter should be used when the \code{microtable$sample_table} object does not have environmental data. 
Under this circumstance, the \code{env_cols} parameter can not be used because no data can be selected.}

\item{\code{character2numeric}}{default FALSE; whether convert the characters or factors to numeric values.}

\item{\code{standardize}}{default FALSE; whether scale environmental variables to zero mean and unit variance.}

\item{\code{complete_na}}{default FALSE; Whether fill the NA (missing value) in the environmental data;
If TRUE, the function can run the interpolation with the \code{mice} package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{data_env} stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(dataset)
data(env_data_16S)
t1 <- trans_env$new(dataset = dataset, add_data = env_data_16S[, 4:11])
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_env-cal_diff"></a>}}
\if{latex}{\out{\hypertarget{method-trans_env-cal_diff}{}}}
\subsection{Method \code{cal_diff()}}{
Differential test of environmental variables across groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_diff(
  group = NULL,
  by_group = NULL,
  method = c("KW", "KW_dunn", "wilcox", "t.test", "anova", "scheirerRayHare", "lm",
    "lme", "glmm")[1],
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{default NULL; a colname of \code{sample_table} used to compare values across groups.}

\item{\code{by_group}}{default NULL; perform differential test among groups (\code{group} parameter) within each group (\code{by_group} parameter).}

\item{\code{method}}{default "KW"; see the following available options:
\describe{
  \item{\strong{'KW'}}{KW: Kruskal-Wallis Rank Sum Test for all groups (>= 2)}
  \item{\strong{'KW_dunn'}}{Dunn's Kruskal-Wallis Multiple Comparisons, see \code{dunnTest} function in \code{FSA} package}
  \item{\strong{'wilcox'}}{Wilcoxon Rank Sum and Signed Rank Tests for all paired groups}
  \item{\strong{'t.test'}}{Student's t-Test for all paired groups}
  \item{\strong{'anova'}}{Duncan's new multiple range test for one-way anova; see \code{duncan.test} function of \code{agricolae} package.
        For multi-factor anova, see \code{aov}}
  \item{\strong{'scheirerRayHare'}}{Scheirer Ray Hare test for nonparametric test used for a two-way factorial experiment; 
        see \code{scheirerRayHare} function of \code{rcompanion} package}
  \item{\strong{'lm'}}{Linear model based on the \code{lm} function}
  \item{\strong{'lme'}}{lme: Linear Mixed Effect Model based on the \code{lmerTest} package. 
        The \code{formula} parameter should be provided.}
  \item{\strong{'glmm'}}{Generalized linear mixed model (GLMM) based on the glmmTMB package. 
        The \code{formula} and \code{family} parameters are needed. 
        Please refer to glmmTMB package to select the family function, e.g. \code{family = glmmTMB::lognormal(link = "log")}.
        The usage of formula is similar with that in 'lme' method.
        For the details of return table, please refer to the help document of trans_diff class.}
}}

\item{\code{...}}{parameters passed to \code{cal_diff} function of \code{\link{trans_alpha}} class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_diff} stored in the object.
  In the data frame, 'Group' column means that the group has the maximum median or mean value across the test groups;
  For non-parametric methods, median value; For t.test, mean value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_diff(group = "Group", method = "KW")
t1$cal_diff(group = "Group", method = "anova")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_env-plot_diff"></a>}}
\if{latex}{\out{\hypertarget{method-trans_env-plot_diff}{}}}
\subsection{Method \code{plot_diff()}}{
Plot environmental variables across groups and add the significance label.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$plot_diff(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{parameters passed to \code{plot_alpha} in \code{\link{trans_alpha}} class. 
Please see \code{plot_alpha} function of \code{\link{trans_alpha}} for all the available parameters.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_env-cal_autocor"></a>}}
\if{latex}{\out{\hypertarget{method-trans_env-cal_autocor}{}}}
\subsection{Method \code{cal_autocor()}}{
Calculate the autocorrelations among environmental variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_autocor(
  group = NULL,
  ggpairs = TRUE,
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  alpha = 0.8,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{group}}{default NULL; a colname of sample_table; used to perform calculations for different groups.}

\item{\code{ggpairs}}{default TRUE; whether use \code{GGally::ggpairs} function to plot the correlation results.
If \code{ggpairs = FALSE}, the function will output a table with all the values instead of a graph.
In this case, the function will call \code{cal_cor} to calculate autocorrelation instead of using the ggpairs function in GGally, 
so please use parameter passing to control more options.}

\item{\code{color_values}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); colors palette.}

\item{\code{alpha}}{default 0.8; the alpha value to add transparency in colors; useful when group is not NULL.}

\item{\code{...}}{parameters passed to \code{GGally::ggpairs} when \code{ggpairs = TRUE} or 
passed to \code{cal_cor} of \code{trans_env} class when \code{ggpairs = FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{ggmatrix} when \code{ggpairs = TRUE} or data.frame object when \code{ggpairs = FALSE}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# Spearman correlation
t1$cal_autocor(upper = list(continuous = GGally::wrap("cor", method= "spearman")))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_env-cal_ordination"></a>}}
\if{latex}{\out{\hypertarget{method-trans_env-cal_ordination}{}}}
\subsection{Method \code{cal_ordination()}}{
Redundancy analysis (RDA) and Correspondence Analysis (CCA) based on the \code{vegan} package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_ordination(
  method = c("RDA", "dbRDA", "CCA")[1],
  feature_sel = FALSE,
  taxa_level = NULL,
  taxa_filter_thres = NULL,
  use_measure = NULL,
  add_matrix = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{default c("RDA", "dbRDA", "CCA")[1]; the ordination method.}

\item{\code{feature_sel}}{default FALSE; whether perform the feature selection based on forward selection method.}

\item{\code{taxa_level}}{default NULL; If use RDA or CCA, provide the taxonomic rank, such as "Phylum" or "Genus";
If use otu_table; please set \code{taxa_level = "OTU"}.}

\item{\code{taxa_filter_thres}}{default NULL; relative abundance threshold used to filter taxa when method is "RDA" or "CCA".}

\item{\code{use_measure}}{default NULL; a name of beta diversity matrix; only available when parameter \code{method = "dbRDA"};
If not provided, use the first beta diversity matrix in the \code{microtable$beta_diversity} automatically.}

\item{\code{add_matrix}}{default NULL; additional distance matrix provided, when the user does not want to use the beta diversity matrix within the dataset;
only available when method = "dbRDA".}

\item{\code{...}}{paremeters passed to \code{dbrda}, \code{rda} or \code{cca} function according to the \code{method} parameter.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_ordination} and \code{res_ordination_R2} stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_ordination(method = "dbRDA", use_measure = "bray")
t1$cal_ordination(method = "RDA", taxa_level = "Genus")
t1$cal_ordination(method = "CCA", taxa_level = "Genus")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_env-cal_ordination_anova"></a>}}
\if{latex}{\out{\hypertarget{method-trans_env-cal_ordination_anova}{}}}
\subsection{Method \code{cal_ordination_anova()}}{
Use anova to test the significance of the terms and axis in ordination.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_ordination_anova(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{parameters passed to \code{anova} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_ordination_terms and res_ordination_axis} stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_ordination_anova()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_env-cal_ordination_envfit"></a>}}
\if{latex}{\out{\hypertarget{method-trans_env-cal_ordination_envfit}{}}}
\subsection{Method \code{cal_ordination_envfit()}}{
Fit each environmental vector onto the ordination to obtain the contribution of each variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_ordination_envfit(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{the parameters passed to \code{vegan::envfit} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_ordination_envfit} stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_ordination_envfit()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_env-trans_ordination"></a>}}
\if{latex}{\out{\hypertarget{method-trans_env-trans_ordination}{}}}
\subsection{Method \code{trans_ordination()}}{
Transform ordination results for the following plot.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$trans_ordination(
  show_taxa = 10,
  adjust_arrow_length = FALSE,
  min_perc_env = 0.1,
  max_perc_env = 0.8,
  min_perc_tax = 0.1,
  max_perc_tax = 0.8
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{show_taxa}}{default 10; taxa number shown in the plot.}

\item{\code{adjust_arrow_length}}{default FALSE; whether adjust the arrow length to be clearer.}

\item{\code{min_perc_env}}{default 0.1; used for scaling up the minimum of env arrow; multiply by the maximum distance between samples and origin.}

\item{\code{max_perc_env}}{default 0.8; used for scaling up the maximum of env arrow; multiply by the maximum distance between samples and origin.}

\item{\code{min_perc_tax}}{default 0.1; used for scaling up the minimum of tax arrow; multiply by the maximum distance between samples and origin.}

\item{\code{max_perc_tax}}{default 0.8; used for scaling up the maximum of tax arrow; multiply by the maximum distance between samples and origin.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_ordination_trans} stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$trans_ordination(adjust_arrow_length = TRUE, min_perc_env = 0.1, max_perc_env = 1)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_env-plot_ordination"></a>}}
\if{latex}{\out{\hypertarget{method-trans_env-plot_ordination}{}}}
\subsection{Method \code{plot_ordination()}}{
plot ordination result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$plot_ordination(
  plot_color = NULL,
  plot_shape = NULL,
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  shape_values = c(16, 17, 7, 8, 15, 18, 11, 10, 12, 13, 9, 3, 4, 0, 1, 2, 14),
  env_text_color = "black",
  env_arrow_color = "grey30",
  taxa_text_color = "firebrick1",
  taxa_arrow_color = "firebrick1",
  env_text_size = 3.7,
  taxa_text_size = 3,
  taxa_text_italic = TRUE,
  plot_type = "point",
  point_size = 3,
  point_alpha = 0.8,
  centroid_segment_alpha = 0.6,
  centroid_segment_size = 1,
  centroid_segment_linetype = 3,
  ellipse_chull_fill = TRUE,
  ellipse_chull_alpha = 0.1,
  ellipse_level = 0.9,
  ellipse_type = "t",
  add_sample_label = NULL,
  env_nudge_x = NULL,
  env_nudge_y = NULL,
  taxa_nudge_x = NULL,
  taxa_nudge_y = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_color}}{default NULL; a colname of \code{sample_table} to assign colors to different groups.}

\item{\code{plot_shape}}{default NULL; a colname of \code{sample_table} to assign shapes to different groups.}

\item{\code{color_values}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); color pallete for different groups.}

\item{\code{shape_values}}{default c(16, 17, 7, 8, 15, 18, 11, 10, 12, 13, 9, 3, 4, 0, 1, 2, 14); a vector for point shape types of groups, see ggplot2 tutorial.}

\item{\code{env_text_color}}{default "black"; environmental variable text color.}

\item{\code{env_arrow_color}}{default "grey30"; environmental variable arrow color.}

\item{\code{taxa_text_color}}{default "firebrick1"; taxa text color.}

\item{\code{taxa_arrow_color}}{default "firebrick1"; taxa arrow color.}

\item{\code{env_text_size}}{default 3.7; environmental variable text size.}

\item{\code{taxa_text_size}}{default 3; taxa text size.}

\item{\code{taxa_text_italic}}{default TRUE; "italic"; whether use "italic" style for the taxa text.}

\item{\code{plot_type}}{default "point"; plotting type of samples;
one or more elements of "point", "ellipse", "chull", "centroid" and "none"; "none" denotes nothing.
  \describe{
    \item{\strong{'point'}}{add point}
    \item{\strong{'ellipse'}}{add confidence ellipse for points of each group}
    \item{\strong{'chull'}}{add convex hull for points of each group}
    \item{\strong{'centroid'}}{add centroid line of each group}
  }}

\item{\code{point_size}}{default 3; point size in plot when "point" is in \code{plot_type}.}

\item{\code{point_alpha}}{default .8; point transparency in plot when "point" is in \code{plot_type}.}

\item{\code{centroid_segment_alpha}}{default 0.6; segment transparency in plot when "centroid" is in \code{plot_type}.}

\item{\code{centroid_segment_size}}{default 1; segment size in plot when "centroid" is in \code{plot_type}.}

\item{\code{centroid_segment_linetype}}{default 3; an integer; the line type related with centroid in plot when "centroid" is in \code{plot_type}.}

\item{\code{ellipse_chull_fill}}{default TRUE; whether fill colors to the area of ellipse or chull.}

\item{\code{ellipse_chull_alpha}}{default 0.1; color transparency in the ellipse or convex hull depending on whether "ellipse" or "centroid" is in \code{plot_type}.}

\item{\code{ellipse_level}}{default .9; confidence level of ellipse when "ellipse" is in \code{plot_type}.}

\item{\code{ellipse_type}}{default "t"; ellipse type when "ellipse" is in \code{plot_type}; see type parameter in \code{stat_ellipse} function of ggplot2 package.}

\item{\code{add_sample_label}}{default NULL; the column name in sample table, if provided, show the point name in plot.}

\item{\code{env_nudge_x}}{default NULL; numeric vector to adjust the env text x axis position; passed to nudge_x parameter of \code{ggrepel::geom_text_repel} function;
default NULL represents automatic adjustment; the length must be same with the row number of \code{object$res_ordination_trans$df_arrows}. For example, 
if there are 5 env variables, env_nudge_x should be something like \code{c(0.1, 0, -0.2, 0, 0)}. 
Note that this parameter and env_nudge_y is generally used when the automatic text adjustment is not very well.}

\item{\code{env_nudge_y}}{default NULL; numeric vector to adjust the env text y axis position; passed to nudge_y parameter of ggrepel::geom_text_repel function;
default NULL represents automatic adjustment; the length must be same with the row number of \code{object$res_ordination_trans$df_arrows}. For example, 
if there are 5 env variables, env_nudge_y should be something like \code{c(0.1, 0, -0.2, 0, 0)}.}

\item{\code{taxa_nudge_x}}{default NULL; numeric vector to adjust the taxa text x axis position; passed to nudge_x parameter of ggrepel::geom_text_repel function;
default NULL represents automatic adjustment; the length must be same with the row number of \code{object$res_ordination_trans$df_arrows_spe}. For example, 
if 3 taxa are shown, taxa_nudge_x should be something like \code{c(0.3, -0.2, 0)}.}

\item{\code{taxa_nudge_y}}{default NULL; numeric vector to adjust the taxa text y axis position; passed to nudge_y parameter of ggrepel::geom_text_repel function;
default NULL represents automatic adjustment; the length must be same with the row number of \code{object$res_ordination_trans$df_arrows_spe}. For example, 
if 3 taxa are shown, taxa_nudge_y should be something like \code{c(-0.2, 0, 0.4)}.}

\item{\code{...}}{paremeters passed to \code{geom_point} for controlling sample points.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_ordination(method = "RDA")
t1$trans_ordination(adjust_arrow_length = TRUE, max_perc_env = 1.5)
t1$plot_ordination(plot_color = "Group")
t1$plot_ordination(plot_color = "Group", plot_shape = "Group", plot_type = c("point", "ellipse"))
t1$plot_ordination(plot_color = "Group", plot_type = c("point", "chull"))
t1$plot_ordination(plot_color = "Group", plot_type = c("point", "centroid"), 
	  centroid_segment_linetype = 1)
t1$plot_ordination(plot_color = "Group", env_nudge_x = c(0.4, 0, 0, 0, 0, -0.2, 0, 0), 
	  env_nudge_y = c(0.6, 0, 0.2, 0.5, 0, 0.1, 0, 0.2))
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_env-cal_mantel"></a>}}
\if{latex}{\out{\hypertarget{method-trans_env-cal_mantel}{}}}
\subsection{Method \code{cal_mantel()}}{
Mantel test between beta diversity matrix and environmental data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_mantel(
  partial_mantel = FALSE,
  add_matrix = NULL,
  use_measure = NULL,
  method = "pearson",
  p_adjust_method = "fdr",
  by_group = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{partial_mantel}}{default FALSE; whether use partial mantel test; If TRUE, use other all measurements as the zdis in each calculation.}

\item{\code{add_matrix}}{default NULL; additional distance matrix provided when the beta diversity matrix in the dataset is not used.}

\item{\code{use_measure}}{default NULL; a name of beta diversity matrix. If necessary and not provided, use the first beta diversity matrix.}

\item{\code{method}}{default "pearson"; one of "pearson", "spearman" and "kendall"; correlation method; see method parameter in \code{vegan::mantel} function.}

\item{\code{p_adjust_method}}{default "fdr"; p.adjust method; see method parameter of \code{p.adjust} function for available options.}

\item{\code{by_group}}{default NULL; one column name or number in sample_table; used to perform mantel test for different groups separately.}

\item{\code{...}}{paremeters passed to \code{mantel} of vegan package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_mantel} in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_mantel(use_measure = "bray")
t1$cal_mantel(partial_mantel = TRUE, use_measure = "bray")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_env-cal_cor"></a>}}
\if{latex}{\out{\hypertarget{method-trans_env-cal_cor}{}}}
\subsection{Method \code{cal_cor()}}{
Calculate the correlations between taxonomic abundance and environmental variables.
Actually, it can also be applied to other correlation between any two variables from two tables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_cor(
  use_data = c("Genus", "all", "other")[1],
  cor_method = c("pearson", "spearman", "kendall", "maaslin2")[1],
  partial = FALSE,
  partial_fix = NULL,
  add_abund_table = NULL,
  filter_thres = 0,
  use_taxa_num = NULL,
  other_taxa = NULL,
  p_adjust_method = "fdr",
  p_adjust_type = c("All", "Taxa", "Env")[1],
  by_group = NULL,
  group_use = NULL,
  group_select = NULL,
  taxa_name_full = TRUE,
  tmp_input_maaslin2 = "tmp_input",
  tmp_output_maaslin2 = "tmp_output",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_data}}{default "Genus"; "Genus", "all" or "other"; 
"Genus" or other taxonomic names (e.g., "Phylum", "ASV"): invoke taxonomic abundance table in \code{taxa_abund} list of the \code{microtable} object; 
"all": merge all the taxonomic abundance tables in \code{taxa_abund} list into one; "other": provide additional taxa names by assigning \code{other_taxa} parameter.}

\item{\code{cor_method}}{default "pearson"; "pearson", "spearman", "kendall" or "maaslin2"; correlation method.
"pearson", "spearman" or "kendall" all refer to the correlation analysis based on the \code{cor.test} function in R.
"maaslin2" is the method in \code{Maaslin2} package for finding associations between metadata and potentially high-dimensional microbial multi-omics data.}

\item{\code{partial}}{default FALSE; whether perform partial correlation based on the \code{ppcor} package.}

\item{\code{partial_fix}}{default NULL; selected environmental variable names used as third group of variables in all the partial correlations. 
If NULL; all the variables (except the one for correlation) in the environmental data will be used as the third group of variables.
Otherwise, the function will control for the provided variables (one or more) in all the partial correlations, 
and the variables in \code{partial_fix} will not be employed anymore in the correlation analysis.}

\item{\code{add_abund_table}}{default NULL; additional data table to be used. Row names must be sample names.}

\item{\code{filter_thres}}{default 0; the abundance threshold, such as 0.0005 when the input is relative abundance.
The features with abundances lower than filter_thres will be filtered. This parameter cannot be applied when add_abund_table parameter is provided.}

\item{\code{use_taxa_num}}{default NULL; integer; a number used to select high abundant taxa; only useful when \code{use_data} parameter is a taxonomic level, e.g., "Genus".}

\item{\code{other_taxa}}{default NULL; character vector containing a series of feature names; available when \code{use_data = "other"}; 
provided names should be standard full names used to select taxa from all the tables in \code{taxa_abund} list of the \code{microtable} object;
please refer to the example.}

\item{\code{p_adjust_method}}{default "fdr"; p.adjust method; see method parameter of \code{p.adjust} function for available options.
\code{p_adjust_method = "none"} can disable the p value adjustment.}

\item{\code{p_adjust_type}}{default "All"; "All", "Taxa" or "Env"; P value adjustment type.
"Env": adjustment for each environmental variable separately; 
"Taxa": adjustment for each taxon separately; 
"All": adjustment for all the data together no matter whether \code{by_group} is provided.}

\item{\code{by_group}}{default NULL; one column name or number in sample_table; calculate correlations for different groups separately.}

\item{\code{group_use}}{default NULL; numeric or character vector to select one column in sample_table for selecting samples; together with group_select.}

\item{\code{group_select}}{default NULL; the group name used; remain samples within the group.}

\item{\code{taxa_name_full}}{default TRUE; Whether use the complete taxonomic name of taxa.}

\item{\code{tmp_input_maaslin2}}{default "tmp_input"; the temporary folder used to save the input files for Maaslin2.}

\item{\code{tmp_output_maaslin2}}{default "tmp_output"; the temporary folder used to save the output files of Maaslin2.}

\item{\code{...}}{parameters passed to \code{Maaslin2} function of \code{Maaslin2} package.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{res_cor} stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t2 <- trans_diff$new(dataset = dataset, method = "rf", group = "Group", rf_taxa_level = "Genus")
t1 <- trans_env$new(dataset = dataset, add_data = env_data_16S[, 4:11])
t1$cal_cor(use_data = "other", p_adjust_method = "fdr", other_taxa = t2$res_diff$Taxa[1:40])
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_env-plot_cor"></a>}}
\if{latex}{\out{\hypertarget{method-trans_env-plot_cor}{}}}
\subsection{Method \code{plot_cor()}}{
Plot correlation heatmap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$plot_cor(
  color_vector = c("#053061", "white", "#A50026"),
  color_palette = NULL,
  pheatmap = FALSE,
  filter_feature = NULL,
  filter_env = NULL,
  ylab_type_italic = FALSE,
  keep_full_name = FALSE,
  keep_prefix = TRUE,
  text_y_order = NULL,
  text_x_order = NULL,
  xtext_angle = 30,
  xtext_size = 10,
  xtext_color = "black",
  ytext_size = NULL,
  ytext_color = "black",
  sig_label_size = 4,
  font_family = NULL,
  cluster_ggplot = "none",
  cluster_height_rows = 0.2,
  cluster_height_cols = 0.2,
  text_y_position = "right",
  mylabels_x = NULL,
  na.value = "grey50",
  trans = "identity",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_vector}}{default \code{c("#053061", "white", "#A50026")}; colors with only three values representing low, middle and high values.}

\item{\code{color_palette}}{default NULL; a customized palette with more color values to be used instead of the parameter \code{color_vector}.}

\item{\code{pheatmap}}{default FALSE; whether use pheatmap package to plot the heatmap.}

\item{\code{filter_feature}}{default NULL; character vector; used to filter features that only have labels in the \code{filter_feature} vector. 
For example, \code{filter_feature = ""} can be used to remove features that only have "", no any "*".}

\item{\code{filter_env}}{default NULL; character vector; used to filter environmental variables that only have labels in the \code{filter_env} vector. 
For example, \code{filter_env = ""} can be used to remove features that only have "", no any "*".}

\item{\code{ylab_type_italic}}{default FALSE; whether use italic type for y lab text.}

\item{\code{keep_full_name}}{default FALSE; whether use the complete taxonomic name.}

\item{\code{keep_prefix}}{default TRUE; whether retain the taxonomic prefix.}

\item{\code{text_y_order}}{default NULL; character vector; provide customized text order for y axis; shown in the plot from the top down.}

\item{\code{text_x_order}}{default NULL; character vector; provide customized text order for x axis.}

\item{\code{xtext_angle}}{default 30; number ranging from 0 to 90; used to adjust x axis text angle.}

\item{\code{xtext_size}}{default 10; x axis text size.}

\item{\code{xtext_color}}{default "black"; x axis text color.}

\item{\code{ytext_size}}{default NULL; y axis text size. NULL means default ggplot2 value.}

\item{\code{ytext_color}}{default "black"; y axis text color.}

\item{\code{sig_label_size}}{default 4; the size of significance label shown in the cell.}

\item{\code{font_family}}{default NULL; font family used in \code{ggplot2}; only available when \code{pheatmap = FALSE}.}

\item{\code{cluster_ggplot}}{default "none"; add clustering dendrogram for \code{ggplot2} based heatmap. Available options: "none", "row", "col" or "both". 
"none": no any clustering used; "row": add clustering for rows; "col": add clustering for columns; "both": add clustering for both rows and columns.
Only available when \code{pheatmap = FALSE}.}

\item{\code{cluster_height_rows}}{default 0.2, the dendrogram plot height for rows; available when \code{cluster_ggplot} is not "none".}

\item{\code{cluster_height_cols}}{default 0.2, the dendrogram plot height for columns; available when \code{cluster_ggplot} is not "none".}

\item{\code{text_y_position}}{default "right"; "left" or "right"; the y axis text position for ggplot2 based heatmap.}

\item{\code{mylabels_x}}{default NULL; provide x axis text labels additionally; only available when \code{pheatmap = TRUE}.}

\item{\code{na.value}}{default "grey50"; the color for the missing values when \code{pheatmap = FALSE}.}

\item{\code{trans}}{default "identity"; the transformation for continuous scales in the legend when \code{pheatmap = FALSE}; 
see the \code{trans} item in \code{ggplot2::scale_colour_gradientn}.}

\item{\code{...}}{paremeters passed to \code{ggplot2::geom_tile} or \code{pheatmap::pheatmap}, depending on the parameter \code{pheatmap} is FALSE or TRUE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
plot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_cor(pheatmap = FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_env-plot_scatterfit"></a>}}
\if{latex}{\out{\hypertarget{method-trans_env-plot_scatterfit}{}}}
\subsection{Method \code{plot_scatterfit()}}{
Scatter plot with fitted line based on the correlation or regression.\cr
	The most important thing is to make sure that the input x and y
 have correponding sample orders. If one of x and y is a matrix, the other will be also transformed to matrix with Euclidean distance.
 Then, both of them are transformed to be vectors. If x or y is a vector with a single value, x or y will be
 assigned according to the column selection of the \code{data_env} in the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$plot_scatterfit(
  x = NULL,
  y = NULL,
  group = NULL,
  group_order = NULL,
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  shape_values = NULL,
  type = c("cor", "lm")[1],
  cor_method = "pearson",
  label_sep = ";",
  label.x.npc = "left",
  label.y.npc = "top",
  label.x = NULL,
  label.y = NULL,
  x_axis_title = "",
  y_axis_title = "",
  point_size = 5,
  point_alpha = 0.6,
  line_size = 0.8,
  line_color = "black",
  line_se = TRUE,
  line_se_color = "grey70",
  line_alpha = 0.5,
  pvalue_trim = 4,
  cor_coef_trim = 3,
  lm_equation = TRUE,
  lm_fir_trim = 2,
  lm_sec_trim = 2,
  lm_squ_trim = 2,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{default NULL; a single numeric or character value, a vector, or a distance matrix used for the x axis.
If x is a single value, it will be used to select the column of \code{data_env} in the object.
If x is a distance matrix, it will be transformed to be a vector.}

\item{\code{y}}{default NULL; a single numeric or character value, a vector, or a distance matrix used for the y axis.
If y is a single value, it will be used to select the column of \code{data_env} in the object.
If y is a distance matrix, it will be transformed to be a vector.}

\item{\code{group}}{default NULL; a character vector; if length is 1, must be a colname of \code{sample_table} in the input dataset;
Otherwise, group should be a vector having same length with x/y (for vector) or column number of x/y (for matrix).}

\item{\code{group_order}}{default NULL; a vector used to order groups, i.e. reorder the legend and colors in plot when group is not NULL; 
If group_order is NULL and group is provided, the function can first check whether the group column of \code{sample_table} is factor. 
If group_order is provided, disable the group orders or factor levels in the \code{group} column of \code{sample_table}.}

\item{\code{color_values}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); color pallete for different groups.}

\item{\code{shape_values}}{default NULL; a numeric vector for point shape types of groups when group is not NULL, see ggplot2 tutorial.}

\item{\code{type}}{default c("cor", "lm")[1]; "cor": correlation; "lm" for regression.}

\item{\code{cor_method}}{default "pearson"; one of "pearson", "kendall" and "spearman"; correlation method.}

\item{\code{label_sep}}{default ";"; the separator string between different label parts.}

\item{\code{label.x.npc}}{default "left"; can be numeric or character vector of the same length as the number of groups and/or panels. If too short, they will be recycled.
\describe{
  \item{numeric}{value should be between 0 and 1. Coordinates to be used for positioning the label, expressed in "normalized parent coordinates"}
  \item{character}{allowed values include: i) one of c('right', 'left', 'center', 'centre', 'middle') for x-axis; ii) and one of 
     c( 'bottom', 'top', 'center', 'centre', 'middle') for y-axis.}
}}

\item{\code{label.y.npc}}{default "top"; same usage with label.x.npc; also see \code{label.y.npc} parameter of \code{ggpubr::stat_cor} function.}

\item{\code{label.x}}{default NULL; x axis absolute position for adding the statistic label.}

\item{\code{label.y}}{default NULL; x axis absolute position for adding the statistic label.}

\item{\code{x_axis_title}}{default ""; the title of x axis.}

\item{\code{y_axis_title}}{default ""; the title of y axis.}

\item{\code{point_size}}{default 5; point size value.}

\item{\code{point_alpha}}{default 0.6; alpha value for the point color transparency.}

\item{\code{line_size}}{default 0.8; line size value.}

\item{\code{line_color}}{default "black"; fitted line color; only available when \code{group = NULL}.}

\item{\code{line_se}}{default TRUE; Whether show the confidence interval for the fitting.}

\item{\code{line_se_color}}{default "grey70"; the color to fill the confidence interval when \code{line_se = TRUE}.}

\item{\code{line_alpha}}{default 0.5; alpha value for the color transparency of line confidence interval.}

\item{\code{pvalue_trim}}{default 4; trim the decimal places of p value.}

\item{\code{cor_coef_trim}}{default 3; trim the decimal places of correlation coefficient.}

\item{\code{lm_equation}}{default TRUE; whether include the equation in the label when \code{type = "lm"}.}

\item{\code{lm_fir_trim}}{default 2; trim the decimal places of first coefficient in regression.}

\item{\code{lm_sec_trim}}{default 2; trim the decimal places of second coefficient in regression.}

\item{\code{lm_squ_trim}}{default 2; trim the decimal places of R square in regression.}

\item{\code{...}}{other arguments passed to \code{geom_text} or \code{geom_label}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_scatterfit(x = 1, y = 2, type = "cor")
t1$plot_scatterfit(x = 1, y = 2, type = "lm", point_alpha = .3)
t1$plot_scatterfit(x = "pH", y = "TOC", type = "lm", group = "Group", line_se = FALSE)
t1$plot_scatterfit(x = 
	 dataset$beta_diversity$bray[rownames(t1$data_env), rownames(t1$data_env)], y = "pH")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_env-print"></a>}}
\if{latex}{\out{\hypertarget{method-trans_env-print}{}}}
\subsection{Method \code{print()}}{
Print the trans_env object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_env-clone"></a>}}
\if{latex}{\out{\hypertarget{method-trans_env-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
