% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{betadiv}
\alias{betadiv}
\title{calcaute beta diversity}
\usage{
betadiv(physeq, distance = "bray", method = "PCoA")
}
\arguments{
\item{physeq}{A \code{phyloseq} object containing merged information of abundance,
taxonomic assignment, sample data including the measured variables and categorical information
of the samples, and / or phylogenetic tree if available.}

\item{distance}{A string character specifying dissimilarity index to be used in calculating pairwise distances (Default index is "bray".).
"unifrac","wunifrac","manhattan", "euclidean", "canberra", "bray", "kulczynski", "jaccard", "gower", "altGower",
"morisita", "horn", "mountford", "raup" , "binomial", "chao", "cao" or "mahalanobis".}

\item{method}{A character string specifying ordination method. All methods available to the \code{ordinate} function
of \code{phyloseq} are acceptable here as well.}
}
\value{
list with beta diversity data.frame and PCs
}
\description{
calcaute beta diversity
}
\examples{
{
data("Physeq")
phy<-normalize(physeq)
res <- betadiv(phy)
}
}
\author{
Kai Guo
}
