% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grpoutputs.R
\name{summary.grpoutputs}
\alias{summary.grpoutputs}
\title{Summary method for grouped outputs}
\usage{
\method{summary}{grpoutputs}(object, ...)
}
\arguments{
\item{object}{Object of class \code{grpoutputs}.}

\item{...}{Currently ignored.}
}
\value{
A list with the following components:
\describe{
 \item{output.dims}{Dimensions for each output, i.e. number of observations
       and number of variables (i.e. output length).}
 \item{group.sizes}{Number of output observations in each group.}
}
}
\description{
Summary method for objects of class \code{grpoutputs}.
}
\examples{
# Determine paths for data folders, each containing outputs for 10 runs of
# the PPHPC model
dir_nl_ok <- system.file("extdata", "nl_ok", package = "micompr")
dir_jex_noshuff <-
 system.file("extdata", "j_ex_noshuff", package = "micompr")
files <- glob2rx("stats400v1*.tsv")

# Create a grpoutputs object
go <-
 grpoutputs(c("o1", "o2"), c(dir_nl_ok, dir_jex_noshuff), c(files, files))

}
