% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGWR_test_bootstrap.R
\name{mgwrsar_bootstrap_test}
\alias{mgwrsar_bootstrap_test}
\title{A bootstrap test for Betas for mgwrsar class model.}
\usage{
mgwrsar_bootstrap_test(x0,x1,B=100,domc=FALSE,ncore=1,
type='standard',eps='H1',df='H1',focal='median',D=NULL)
}
\arguments{
\item{x0}{The H0 mgwrsar model}

\item{x1}{The H1 mgwrsar model}

\item{B}{number of bootstrap repetitions, default 100}

\item{domc}{If TRUE, doParallel parallelization}

\item{ncore}{number of cores}

\item{type}{type of bootstap : 'wild','Rademacher','spatial' or 'standard' (default)}

\item{eps}{Hypothesis under wich residuals are simulated,  'H0' or 'H1' (default)}

\item{df}{Hypothesis under wich degree of freedom is estimated.}

\item{focal}{see sample_stat help}

\item{D}{A matrix of distance}
}
\value{
The value of the statictics test and a p ratio.
}
\description{
A bootstrap test for Betas for mgwrsar class model.
}
\examples{
\donttest{
 data(data_mgwrsar)
 coord=as.matrix(mydata[,c("x_lat","y_lon")])
 model_GWR<-MGWRSAR(formula = 'Y_gwr~X1+X2+X3', data = mydata, coord=coord,
  fixed_vars=NULL,kernels=c('gauss_adapt'), H=20,
  Model = 'GWR',control=list(SE=TRUE))

 model_MGWR<-MGWRSAR(formula = 'Y_gwr~X1+X2+X3', data = mydata, coord=coord,
 fixed_vars='Intercept',kernels=c('gauss_adapt'), H=20,
 Model = 'MGWR',control=list(SE=TRUE))

 mgwrsar_bootstrap_test(model_MGWR,model_GWR,domc=FALSE,B=30)
}
}
\seealso{
mgwrsar_bootstrap_test_all
}
