% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCoXpGene_function.R
\name{makeCoXpGene}
\alias{makeCoXpGene}
\title{Tests pairwise co-expression for normalized expression data}
\usage{
makeCoXpGene(mgl, genes = c(), makePlot = FALSE, saveFile = FALSE,
  data = c(7, 8, 10), tissue = c("All", "Adipose - Subcutaneous",
  "Adipose - Visceral (Omentum)", "Adrenal Gland", "Artery - Aorta",
  "Artery - Coronary", "Artery - Tibial", "Bladder", "Brain - Amygdala",
  "Brain - Anterior cingulate cortex (BA24)", "Brain - Caudate (basal ganglia)",
  "Brain - Cerebellar Hemisphere", "Brain - Cerebellum", "Brain - Cortex",
  "Brain - Frontal Cortex (BA9)", "Brain - Hippocampus", "Brain - Hypothalamus",
  "Brain - Nucleus accumbens (basal ganglia)",
  "Brain - Putamen (basal ganglia)", "Brain - Spinal cord (cervical c-1)",     
  "Brain - Substantia nigra", "Breast - Mammary Tissue",
  "Cells - EBV-transformed lymphocytes", "Cells - Transformed fibroblasts",
  "Cervix - Ectocervix", "Cervix - Endocervix", "Colon - Sigmoid",
  "Colon - Transverse", "Esophagus - Gastroesophageal Junction",
  "Esophagus - Mucosa", "Esophagus - Muscularis", "Fallopian Tube",
  "Heart - Atrial Appendage", "Heart - Left Ventricle", "Kidney - Cortex",
  "Liver", "Lung", "Minor Salivary Gland", "Muscle - Skeletal",
  "Nerve - Tibial", "Ovary", "Pancreas",      "Pituitary", "Prostate",
  "Skin - Not Sun Exposed (Suprapubic)", "Skin - Sun Exposed (Lower leg)",
  "Small Intestine - Terminal Ileum", "Spleen", "Stomach", "Testis", "Thyroid",
  "Uterus", "Vagina", "Whole Blood"))
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{genes}{Character vector indicating genes to be considered (note gene names must match names(mgl))}

\item{makePlot}{Logical flag - TRUE indicates pdf file named 'CoXpGene.pdf'
will be saved in the current directory}

\item{saveFile}{Logical flag - TRUE indicates csv file named 'CoXpGene.csv'
will be saved in the current directory. 'CoXpGene.csv' contains cor.test results}

\item{data}{Number corresponding to element of mgl containing data of interest: 8 for count data and 10 for RPKM}

\item{tissue}{Character vector indicating tissues to be considered (note tissue names must match those provided here: c('All', Adipose - Subcutaneous', 'Adipose - Visceral (Omentum)', 'Adrenal Gland', 'Artery - Aorta', 'Artery - Coronary', 'Artery - Tibial', 'Bladder', 'Brain - Amygdala', 'Brain - Anterior cingulate cortex (BA24)', 'Brain - Caudate (basal ganglia)', 'Brain - Cerebellar Hemisphere', 'Brain - Cerebellum', 'Brain - Cortex', 'Brain - Frontal Cortex (BA9)', 'Brain - Hippocampus', 'Brain - Hypothalamus', 'Brain - Nucleus accumbens (basal ganglia)', 'Brain - Putamen (basal ganglia)', 'Brain - Spinal cord (cervical c-1)', 'Brain - Substantia nigra', 'Breast - Mammary Tissue', 'Cells - EBV-transformed lymphocytes', 'Cells - Transformed fibroblasts', 'Cervix - Ectocervix', 'Cervix - Endocervix', 'Colon - Sigmoid', 'Colon - Transverse', 'Esophagus - Gastroesophageal Junction', 'Esophagus - Mucosa', 'Esophagus - Muscularis', 'Fallopian Tube', 'Heart - Atrial Appendage', 'Heart - Left Ventricle', 'Kidney - Cortex', 'Liver', 'Lung', 'Minor Salivary Gland', 'Muscle - Skeletal', 'Nerve - Tibial', 'Ovary', 'Pancreas', 'Pituitary', 'Prostate', 'Skin - Not Sun Exposed (Suprapubic)', 'Skin - Sun Exposed (Lower leg)', 'Small Intestine - Terminal Ileum', 'Spleen', 'Stomach', 'Testis', 'Thyroid', 'Uterus', 'Vagina', 'Whole Blood'))}
}
\description{
\code{makeCoXpGene} returns a list of cor.test output for each user-defined gene pair in a given tissue
}
\details{
Uses the cor.test function in R to test for co-expression between genes.  Option to generate scatter plots and a summary table of the correlations to be saved as a pdf and csv, respectively.  Any number of genes and tissues can be included.  Normalized (data = 7), counts (data = 8), or RPKM (data = 10) can be used.
}
\examples{
exMgl() -> myMgl
makeCoXpGene(myMgl, gene = c('RP11-109G10.2', 'NCOA4'), makePlot = FALSE, 
    saveFile = FALSE, data = 7, tissue = c('Prostate')) -> results

}
\seealso{
Other output: \code{\link{makeAeiPlot}},
  \code{\link{makeCoXpTranscript}},
  \code{\link{makeDnaseSig}}, \code{\link{makeGoSearch}},
  \code{\link{makeGo}}, \code{\link{makeMultiEqtl}},
  \code{\link{makeOverlapTable}},
  \code{\link{makeOverlap}},
  \code{\link{makePhenotypeSearch}},
  \code{\link{makePhenotypes}},
  \code{\link{makeSnpSearch}}, \code{\link{makeSnps}},
  \code{\link{makeSummary}}
}

