% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeAeiPlot_function.R
\name{makeAeiPlot}
\alias{makeAeiPlot}
\title{Plot GTEx AEI ratios}
\usage{
makeAeiPlot(mgl, gene = c(), saveFile = FALSE)
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{gene}{String indicating gene to be considered (note gene name must match names(mgl))}

\item{saveFile}{A logical flag indicating whether a csv file ('AeiPlot.csv') should be saved in the current directory.}
}
\description{
\code{makeCorGene} plots AEI ratios person by person and returns a dataframe with allelic ratios for a given gene
}
\details{
Uses ggplot function to plot allelic ratios published by GTEx.  Each individual is plotted a separate graph. Tissues are displayed on the x-axis and corresponding ratios on the y.  SNPs are displayed in different colors and annotations in different shapes.Option to save a summarytable (csv) of allelic ratios.  Only one gene at a time.
}
\examples{
\dontrun{makeAeiPlot(myMgl, gene = c('NCOA4'), saveFile = FALSE)}

}
\seealso{
Other output: \code{\link{makeCoXpGene}},
  \code{\link{makeCoXpTranscript}},
  \code{\link{makeDnaseSig}}, \code{\link{makeGoSearch}},
  \code{\link{makeGo}}, \code{\link{makeMultiEqtl}},
  \code{\link{makeOverlapTable}},
  \code{\link{makeOverlap}},
  \code{\link{makePhenotypeSearch}},
  \code{\link{makePhenotypes}},
  \code{\link{makeSnpSearch}}, \code{\link{makeSnps}},
  \code{\link{makeSummary}}
}

