% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_multi_random_effect.R,
%   R/plot_random_effect.R
\name{plot.multi.random.effect}
\alias{plot.multi.random.effect}
\alias{plot.random.effect}
\title{Plotting random effects}
\usage{
\method{plot}{multi.random.effect}(x, trans = identity, ...)

\method{plot}{random.effect}(x, trans = identity, ...)
}
\arguments{
\item{x}{a random effect object, extracted using \link[mgcViz:sm]{mgcViz::sm}.}

\item{trans}{monotonic function to apply to the fit, confidence intervals and residuals,
before plotting. Monotonicity is not checked.}

\item{...}{currently unused.}
}
\value{
An object of class \code{plotSmooth}.
}
\description{
This is the plotting method for random effects (simple random intercepts).
}
\examples{
library(mgcViz)
b <- gam(travel~s(Rail,bs="re"), data=Rail, method="REML")
b <- getViz(b)
plot(sm(b, 1)) + l_fitLine(colour = 2, linetype = 2) + l_points() + 
  l_ciLine(colour = 4, linetype = 3)

plot(sm(b, 1)) + l_ciPoly() + l_points()

# Default
plot(b)

###
# Quantile GAM version
###
b <- mqgamV(travel~s(Rail,bs="re"), data=as.data.frame(Rail), qu = c(0.2, 0.4, 0.6, 0.8))

plot(sm(b, 1)) + l_ciPoly() + l_points()

# Default
plot(b)

}
