\name{mfrBinomialEdge}
\alias{mfrBinomialEdge}
\alias{graph2BinomialEdgeIdeal}
\title{
Binomial Edge Ideals
}
\description{
Computing the minimal free resolution of binomial edge ideals.
}
\usage{
mfrBinomialEdge(g, resString = "res")
graph2BinomialEdgeIdeal(g, resString = "res")
}
\arguments{
  \item{g}{
a graph.
}
  \item{resString}{
the string defining the resolution function used by Singular.
}
}
\details{
A binomial edge ideal is the ideal generated by \eqn{x_iy_j-x_jy_i} for all
edges ij. \code{graph2BinomialEdgeIdeal} produces the string that is used in
the call to Singular to compute the minimal free resolution. Singular must
be installed and callable by the package in order for this to work.
}
\value{
a minimal free resolution.
}
\references{
Herzog, Hibi, Hreinsd'{o}ttir, Kahle and Rauh, "Binomial edge ideals and
conditional independence statements", arXiv:4717v2.
}
\author{
David J. Marchette, \email{dmarchette@gmail.com}
}
\note{
Aside from the complete graph, which has the same resolution for binomial edge
ideals as for regular edge ideals, this function will only work if Singular is
installed. Because Singular is used, it is recommended that you not try this on
graphs with more than about a dozen edges.
}

\seealso{
\code{\link{mfr}}.
}
\examples{
g <- erdos.renyi.game(10,.1)
graph2BinomialEdgeIdeal(g)
\dontrun{
mfrBinomialEdge(g)
}
}
\keyword{ graphs }
