% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rmev_wrapper.R
\name{rmevspec}
\alias{rmevspec}
\title{Random samples from spectral distributions of multivariate extreme value models.}
\usage{
rmevspec(n, d, param, sigma, model = c("log", "neglog", "bilog", "negbilog",
  "hr", "xstud", "ct", "dirmix"), weights, vario, loc)
}
\arguments{
\item{n}{number of observations}

\item{d}{dimension of sample}

\item{param}{parameter vector for the logistic, bilogistic, negative bilogistic and Dirichlet (Coles and Tawn) model.
Parameter matrix for the Dirichlet mixture. Degree of freedoms for extremal student model.}

\item{sigma}{covariance matrix for Husler-Reiss and extremal Student-t distributions}

\item{model}{choice between 1-parameter logistic and negative logistic, bilogistic, negative bilogistic and extremal Dirichlet,
the Brown-Resnick and extremal Student max-stable process (which generate the Husler-Reiss MEV distribution), or the Dirichlet mixture.}

\item{weights}{vector of length \code{m} for the \code{m} mixture components. Must sum to one}

\item{vario}{function specifying the variogram. Used only if provided in conjonction with \code{loc} and if \code{sigma} is missing}

\item{loc}{\code{d} by \code{k} matrix of location, used as input in the variogram \code{vario} or as parameter in the Smith \code{smith} model.}
}
\value{
an \code{n} by \code{d} exact sample from the corresponding multivariate extreme value model
}
\description{
Generate from \eqn{Q_i}{Qi}, the spectral measure of a given multivariate extreme value model
}
\details{
The vector param differs depending on the model
\itemize{
 \item \code{log}: one dimensional parameter greater than 1
 \item \code{neglog}: one dimensional positive parameter
 \item \code{bilog}: \code{d}-dimensional vector of parameters in \eqn{[0,1]}
 \item \code{negbilog}: \code{d}-dimensional vector of negative parameters
 \item \code{ct}: \code{d}-dimensional vector of positive (a)symmetry parameters. Alternatively, a \eqn{d+1}
 vector consisting of the \code{d} Dirichlet parameters and the last entry is an index of regular variation in \code{(0, 1]} treated as scale
 \item \code{xstud}: one dimensional parameter corresponding to degrees of freedom \code{alpha}
 \item \code{dirmix}: \code{d} by \code{m}-dimensional matrix of positive (a)symmetry parameters
}
}
\examples{
set.seed(1)
rmevspec(n=100, d=3, param=2.5, model="log")
rmevspec(n=100, d=3, param=2.5, model="neglog")
rmevspec(n=100, d=4, param=c(0.2,0.1,0.9,0.5), model="bilog")
rmevspec(n=100, d=2, param=c(0.8,1.2), model="ct") #Dirichlet model
rmevspec(n=100, d=2, param=c(0.8,1.2,0.5), model="ct") #with additional scale parameter
#Variogram gamma(h) = scale*||h||^alpha
scale <- 0.5; alpha <- 1
vario <- function(x) scale*sqrt(sum(x^2))^alpha
#grid specification
grid.loc <- as.matrix(expand.grid(runif(4), runif(4)))
rmevspec(n=100, vario=vario,loc=grid.loc, model="hr")
## Example with Dirichlet mixture
alpha.mat <- cbind(c(2,1,1),c(1,2,1),c(1,1,2))
rmevspec(n=100, param=alpha.mat, weights=rep(1/3,3), model="dirmix")
}
\author{
Leo Belzile
}
\references{
Dombry, Engelke and Oesting (2015). Exact simulation of max-stable processes,
\emph{arXiv:1506.04430v1}, 1--24.

Boldi (2009). A note on the representation of parametric models for multivariate extremes.
\emph{Extremes} \bold{12}, 211--218.
}

