% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spunif.R
\name{spunif}
\alias{spunif}
\title{Semi-parametric marginal transformation to uniform}
\usage{
spunif(x, thresh, scale = NULL, shape = NULL)
}
\arguments{
\item{x}{matrix or vector of data}

\item{thresh}{vector of marginal thresholds}

\item{scale}{vector of marginal scale parameters for the generalized Pareto}

\item{shape}{vector of marginal shape parameters for the generalized Pareto}
}
\value{
a matrix or vector of the same dimension as \code{x}, with pseudo-uniform observations
}
\description{
The function \code{spunif} transforms a matrix or vector of data \code{x}
to the pseudo-uniform scale using a semiparametric transform. Data below the threshold
are transformed to pseudo-uniforms using a rank transform, while data above the threshold
are assumed to follow a generalized Pareto distribution. The parameters of the latter are
estimated using maximum likelihood if either \code{scale = NULL} or \code{shape = NULL}.
}
\examples{
x <- rmev(1000, d = 3, param = 2, model = 'log')
thresh <- apply(x, 2, quantile, 0.95)
spunif(x, thresh)
}
\author{
Leo Belzile
}
