# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Distance matrix with geometric anisotropy
#'
#' The function computes the distance between locations, with geometric anisotropy.
#' The parametrization assumes there is a scale parameter, say \eqn{\sigma}, so that \code{scale}
#' is the distortion for the second component only. The angle \code{rho} must lie in
#' \eqn{[-\pi/2, \pi/2]}. The dilation and rotation matrix is 
#' \deqn{\left(\begin{matrix} \cos(\rho) & \sin(\rho) \\ - \sigma\sin(\rho) & \sigma\cos(\rho) \end{matrix} \right)}
#' @param loc a \code{d} by 2 matrix of locations giving the coordinates of a site per row.
#' @param scale numeric vector of length 1, greater than 1.
#' @param rho angle for the anisotropy, must be larger than \eqn{\pi/2} in modulus.
#' @return a \code{d} by \code{d} square matrix of pairwise distance
#' @export
distg <- function(loc, scale, rho) {
    .Call(`_mev_distg`, loc, scale, rho)
}

.EuclideanWeights <- function(x, mu) {
    .Call(`_mev_EuclideanWeights`, x, mu)
}

.emplik_intern <- function(z, mu, lam, eps, M = 1e30, thresh = 1e-12, itermax = 1000L) {
    .Call(`_mev_emplik_intern`, z, mu, lam, eps, M, thresh, itermax)
}

.Pickands_emp <- function(s, ang, wts) {
    .Call(`_mev_Pickands_emp`, s, ang, wts)
}

ldirfn <- function(param) {
    .Call(`_mev_ldirfn`, param)
}

.loocvdens <- function(nu, ang, wts, loowts) {
    .Call(`_mev_loocvdens`, nu, ang, wts, loowts)
}

Zhang_Stephens <- function(x, init, adapt_sd = 0.1, adapt = TRUE, burnin = 1000L, niter = 10000L, thin = 1L, method = 1L) {
    .Call(`_mev_Zhang_Stephens`, x, init, adapt_sd, adapt, burnin, niter, thin, method)
}

#' Random variate generation for Dirichlet distribution on \eqn{S_{d}}{Sd}
#'
#' A function to sample Dirichlet random variables, based on the representation as ratios of Gamma.
#' Note that the RNG will generate on the full simplex and the sum to one constraint is respected
#' here
#'
#' @param n sample size
#' @param alpha vector of parameter
#' @param normalize boolean. If \code{FALSE}, the function returns Gamma variates with parameter \code{alpha}.
#' @export
#' @return sample of dimension \code{d} (size of alpha) from the Dirichlet distribution.
#' @examples rdir(n=100, alpha=c(0.5,0.5,2),TRUE)
#' rdir(n=100, alpha=c(3,1,2),FALSE)
rdir <- function(n, alpha, normalize = TRUE) {
    .Call(`_mev_rdir`, n, alpha, normalize)
}

#' Multivariate Normal distribution sampler
#'
#' Sampler derived using the eigendecomposition of the covariance
#' matrix \code{Sigma}. The function uses the Armadillo random normal generator
#'
#' @param n sample size
#' @param mu mean vector. Will set the dimension
#' @param Sigma a square covariance matrix, of same dimension as \code{mu}.
#' No sanity check is performed to validate that the matrix is p.s.d., so use at own risk
#' @export
#' @return an \code{n} sample from a multivariate Normal distribution
#' @examples
#' mvrnorm(n=10, mu=c(0,2), Sigma=diag(2))
mvrnorm <- function(n, mu, Sigma) {
    .Call(`_mev_mvrnorm`, n, mu, Sigma)
}

.mvrnorm_chol <- function(n, mu, Sigma_chol) {
    .Call(`_mev_mvrnorm_chol`, n, mu, Sigma_chol)
}

#' Multivariate Normal distribution sampler (Rcpp version), derived using the eigendecomposition
#' of the covariance matrix Sigma. The function utilizes the arma random normal generator
#'
#' @param n sample size
#' @param Mu mean vector. Will set the dimension
#' @param Xmat covariance matrix, of same dimension as \code{Mu} (and square matrix).
#' No sanity check is performed to validate that the matrix is symmetric, so use at own risk
#' @keywords internal
#' @return an \code{n} sample from a multivariate Normal distribution
#'
.mvrnorm_arma <- function(n, Mu, Xmat, eigen = TRUE) {
    .Call(`_mev_mvrnorm_arma`, n, Mu, Xmat, eigen)
}

.mvrnorm_chol_arma <- function(n, Mu, Chol_Cov) {
    .Call(`_mev_mvrnorm_chol_arma`, n, Mu, Chol_Cov)
}

.mvrt <- function(n, scaleMat, dof, loc) {
    .Call(`_mev_mvrt`, n, scaleMat, dof, loc)
}

.mvrtXstud <- function(n, sigma, alpha, index) {
    .Call(`_mev_mvrtXstud`, n, sigma, alpha, index)
}

.dmvnorm_arma <- function(x, mean, sigma, log = FALSE) {
    .Call(`_mev_dmvnorm_arma`, x, mean, sigma, log)
}

.dmvnorm_chol_arma <- function(x, mean, chol_sigma, logv = FALSE) {
    .Call(`_mev_dmvnorm_chol_arma`, x, mean, chol_sigma, logv)
}

#' Generate from logistic \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is probability of extremal function scaled by a Frechet variate
#'
#' @param d dimension of the 1-sample
#' @param index index of the location. An integer in 0, ..., \eqn{d-1}
#' @param theta a one-dimensional parameter for the logistic model, strictly greater than 1.
#'
#' @keywords internal
#' @return a \code{d}-vector from \eqn{P_x}
.rPlog <- function(d, index, theta) {
    .Call(`_mev_rPlog`, d, index, theta)
}

#' Generate from negative logistic \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is probability of extremal function scaled by a Frechet variate
#'
#' @param d dimension of the 1-sample
#' @param index index of the location. An integer in 0, ..., \eqn{d-1}
#' @param theta a one-dimensional parameter for the negative logistic model
#'
#' @keywords internal
#' @return a \code{d}-vector from \eqn{P_x}
.rPneglog <- function(d, index, theta) {
    .Call(`_mev_rPneglog`, d, index, theta)
}

#' Generate from extremal Dirichlet \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is the probability of extremal functions from a Dirichlet mixture
#'
#' @param d dimension of the 1-sample
#' @param index index of the location. An integer in 0, ..., \eqn{d-1}
#' @param alpha a \eqn{d \times n} dimensional vector of positive parameter values for the Dirichlet vector
#' @param weight a \code{m} vector of mixture weights, which sum to 1
#' @return a \code{d}-vector from \eqn{P_x}
#' @keywords internal
.rPdirmix <- function(d, index, alpha, weight) {
    .Call(`_mev_rPdirmix`, d, index, alpha, weight)
}

#' Generate from bilogistic \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is the probability of extremal functions
#'
#' @param d dimension of the 1-sample
#' @param index index of the location. An integer in 0, ..., \eqn{d-1}
#' @param alpha a \eqn{d} dimensional vector of positive parameter values for the Dirichlet vector
#' @return a \code{d}-vector from \eqn{P_x}
#' @keywords internal
.rPbilog <- function(d, index, alpha) {
    .Call(`_mev_rPbilog`, d, index, alpha)
}

.rPexstud_old <- function(index, sigma, al) {
    .Call(`_mev_rPexstud_old`, index, sigma, al)
}

#' Generate from extremal Student-t \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is probability of extremal function
#'
#' @param index index of the location. An integer in 0, ..., \eqn{d-1}
#' @param sigma a positive semi-definite correlation matrix
#' @param cholesky Cholesky root of transformed correlation matrix
#' @param al the alpha parameter in Proposition 7. Corresponds to degrees of freedom - 1
#' @keywords internal
#' @return a \code{d}-vector from \eqn{P_x}
.rPexstud <- function(index, cholesky, sigma, al) {
    .Call(`_mev_rPexstud`, index, cholesky, sigma, al)
}

#' Generate from extremal Husler-Reiss distribution \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is probability of extremal function
#'
#' @param index index of the location. An integer in 0, ..., \eqn{d-1}
#' @param Sigma a covariance matrix formed from the symmetric square matrix of coefficients \eqn{\lambda^2}
#' @param cholesky the Cholesky root of \code{Sigma}
#' @return a \code{d}-vector from \eqn{P_x}
#' @keywords internal
.rPHuslerReiss <- function(index, cholesky, Sigma) {
    .Call(`_mev_rPHuslerReiss`, index, cholesky, Sigma)
}

.rPHuslerReiss_old <- function(index, Lambda) {
    .Call(`_mev_rPHuslerReiss_old`, index, Lambda)
}

#' Generate from Brown-Resnick process \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is probability of extremal function
#'
#' @param index index of the location. An integer in 0, ..., \eqn{d-1}
#' @param Sigma a positive definite covariance matrix
#' @keywords internal
#' @return a \code{d}-vector from \eqn{P_x}
.rPBrownResnick <- function(index, Sigma_chol, Sigma) {
    .Call(`_mev_rPBrownResnick`, index, Sigma_chol, Sigma)
}

#' Generate from Smith model (moving maxima) \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is probability of extremal function
#'
#' @param index index of the location. An integer in 0, ..., \eqn{d-1}
#' @param Sigma_chol the Cholesky root of the covariance matrix
#' @param loc location matrix
#' @keywords internal
#' @return a \code{d}-vector from \eqn{P_x}
.rPSmith <- function(index, Sigma_chol, loc) {
    .Call(`_mev_rPSmith`, index, Sigma_chol, loc)
}

#' Generate from extremal Dirichlet \eqn{Y \sim {P_x}}, where
#' \eqn{P_{x}} is the probability of extremal functions from the Dirichlet model of
#' Coles and Tawn.
#'
#' Note: we generate from the Dirichlet rather than the Gamma distribution, since the former is parallelized
#'
#' @param d dimension of the 1-sample
#' @param index index of the location. An integer in 0, ..., \eqn{d-1}
#' @param alpha a \eqn{d} dimensional vector of positive parameter values for the Dirichlet vector, or
#' \eqn{d+1} if the last entry is the index of regular variation of the model, a constant in \code{(0, 1]}
#' @param irv should the usual model (\code{FALSE}) or the general scaled version (\code{TRUE}) be used
#' @keywords internal
#' @return a \code{d}-vector from \eqn{P_x}
.rPdir <- function(d, index, alpha, irv = FALSE) {
    .Call(`_mev_rPdir`, d, index, alpha, irv)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the logistic model
#'
#' Simulation algorithm of Dombry et al. (2015)
#'
#' @param n sample size
#' @param theta a one-dimensional parameter
#' @keywords internal
#' @references Dombry, Engelke and Oesting (2016). Exact simulation of max-stable processes,
#' \emph{Biometrika}, \bold{103}(2), 303--317.
#'
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rlogspec <- function(n, d, theta) {
    .Call(`_mev_rlogspec`, n, d, theta)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the negative logistic model
#'
#' Simulation algorithm of Dombry et al. (2016)
#'
#' @param n sample size
#' @param theta a one-dimensional parameter
#' @keywords internal
#' @references Dombry, Engelke and Oesting (2016). Exact simulation of max-stable processes,
#' \emph{Biometrika}, \bold{103}(2), 303--317.
#'
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rneglogspec <- function(n, d, theta) {
    .Call(`_mev_rneglogspec`, n, d, theta)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the Dirichlet mixture model
#'
#' Simulation algorithm of Dombry et al. (2015)
#'
#' @param n sample size
#' @param d dimension of the 1-sample
#' @param alpha a \eqn{d \times n} dimensional vector of positive parameter values for the Dirichlet vector
#' @param weight a \code{m} vector of mixture weights, which sum to 1
#' @keywords internal
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rdirmixspec <- function(n, d, alpha, weight) {
    .Call(`_mev_rdirmixspec`, n, d, alpha, weight)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the bilogistic model
#'
#' Simulation algorithm of Boldi (2009) for the bilogistic model
#'
#' @param n sample size
#' @param alpha vector of parameter of dimension \code{d}
#'
#' @references Boldi (2009). A note on the representation of parametric models
#' for multivariate extremes. \emph{Extremes} \bold{12}, 211--218.
#' @keywords internal
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rbilogspec <- function(n, alpha) {
    .Call(`_mev_rbilogspec`, n, alpha)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the extremal Student model
#'
#' @param sigma a positive semi-definite covariance matrix with unit variance
#' @param al the alpha parameter in Proposition 7. Corresponds to degrees of freedom - 1
#' @keywords internal
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rexstudspec <- function(n, sigma, al) {
    .Call(`_mev_rexstudspec`, n, sigma, al)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the Husler-Reiss model
#'
#' @param Lambda an symmetric square matrix of coefficients \eqn{\lambda^2}
#' @keywords internal
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rhrspec <- function(n, Lambda) {
    .Call(`_mev_rhrspec`, n, Lambda)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the Brown-Resnick model
#'
#' Simulation algorithm of Dombry et al. (2015)
#'
#' @param n sample size
#' @param Sigma_chol Cholesky root of \code{Sigma}
#' @param Sigma \code{d}-dimensional covariance matrix
#'
#' @references Dombry, Engelke and Oesting (2016). Exact simulation of max-stable processes,
#' \emph{Biometrika}, \bold{103}(2), 303--317.
#' @keywords internal
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rbrspec <- function(n, Sigma_chol, Sigma) {
    .Call(`_mev_rbrspec`, n, Sigma_chol, Sigma)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the Smith model (moving maxima)
#'
#' Simulation algorithm of Dombry et al. (2015)
#'
#' @param n sample size
#' @param Sigma_chol Cholesky decomposition of the \code{d}-dimensional covariance matrix (upper triangular)
#' @param loc location matrix
#'
#' @references Dombry, Engelke and Oesting (2016). Exact simulation of max-stable processes,
#' \emph{Biometrika}, \bold{103}(2), 303--317.
#' @keywords internal
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rsmithspec <- function(n, Sigma_chol, loc) {
    .Call(`_mev_rsmithspec`, n, Sigma_chol, loc)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the extremal Dirichlet
#' model
#'
#' This model was introduced in Coles and Tawn (1991); the
#' present method uses the simulation algorithm of Boldi (2009) for the extremal Dirichlet model
#'
#' @param n sample size
#' @param d dimension of sample
#' @param alpha vector of Dirichlet parameters of dimension \code{d}, or \eqn{d+1} vector with the \code{d} Dirichlet parameters and an index of regular variation in \eqn{[0, 1]}
#' @param irv should the usual model (\code{FALSE}) or the general scaled version (\code{TRUE}) be used
#' @keywords internal
#' @references Boldi (2009). A note on the representation of parametric models
#' for multivariate extremes. \emph{Extremes} \bold{12}, 211--218.
#'
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rdirspec <- function(n, d, alpha, irv = FALSE) {
    .Call(`_mev_rdirspec`, n, d, alpha, irv)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the pairwise Beta model
#'
#' This model was introduced in Cooley, Davis and Naveau (2010).
#' The sample is drawn from a mixture and the algorithm follows from the proof of Theorem 1 in Ballani and Schlather (2011)
#' and is written in full in Algorithm 1 of Sabourin et al. (2013).
#'
#' @param n sample size
#' @param alpha concentration parameter
#' @param beta vector of all pairwise component (lexicographic order, by row)
#' @return a matrix of samples from the angular distribution
#' @references Cooley, D., R.A. Davis and P. Naveau (2010). The pairwise beta distribution: A flexible parametric multivariate model for extremes, \emph{Journal of Multivariate Analysis}, \bold{101}(9), 2103--2117.
#' @references Ballani, D. and M. Schlather (2011). A construction principle for multivariate extreme value distributions, \emph{Biometrika}, \bold{98}(3), 633--645.
#' @references Sabourin, A., P. Naveau and A. Fougeres (2013). Bayesian model averaging for extremes, \emph{Extremes}, \bold{16}, 325--350.
#' @author Leo Belzile
#' @keywords internal
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rpairbetaspec <- function(n, d, alpha, beta) {
    .Call(`_mev_rpairbetaspec`, n, d, alpha, beta)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the pairwise exponential model
#'
#' The sample is drawn from a mixture and the algorithm follows from the proof of Theorem 1 in Ballani and Schlather (2011).
#'
#' @param n sample size
#' @param alpha concentration parameter
#' @param beta vector of all pairwise component (lexicographic order, by row)
#' @return a matrix of samples from the angular distribution
#' @references Ballani, D. and M. Schlather (2011). A construction principle for multivariate extreme value distributions, \emph{Biometrika}, \bold{98}(3), 633--645.
#' @author Leo Belzile
#' @keywords internal
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rpairexpspec <- function(n, d, alpha, beta) {
    .Call(`_mev_rpairexpspec`, n, d, alpha, beta)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the weighted Dirichlet model
#'
#' This model was introduced in Ballani and Schlather (2011).
#' @param n sample size
#' @param alpha vector of concentration parameters
#' @param beta vector of Dirichlet components
#' @return a matrix of samples from the angular distribution
#' @references Ballani, D. and M. Schlather (2011). A construction principle for multivariate extreme value distributions, \emph{Biometrika}, \bold{98}(3), 633--645.
#' @author Leo Belzile
#' @keywords internal
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rwdirbsspec <- function(n, d, alpha, beta) {
    .Call(`_mev_rwdirbsspec`, n, d, alpha, beta)
}

#' Generates from \eqn{Q_i}{Qi}, the spectral measure of the weighted exponential model
#'
#' This model was introduced in Ballani and Schlather (2011).
#' @param n sample size
#' @param alpha vector of concentration parameters
#' @param beta vector of Dirichlet components
#' @return a matrix of samples from the angular distribution
#' @references Ballani, D. and M. Schlather (2011). A construction principle for multivariate extreme value distributions, \emph{Biometrika}, \bold{98}(3), 633--645.
#' @author Leo Belzile
#' @keywords internal
#' @return an \code{n} by \code{d} sample from the spectral distribution
.rwexpbsspec <- function(n, d, alpha, beta) {
    .Call(`_mev_rwexpbsspec`, n, d, alpha, beta)
}

#' Multivariate extreme value distribution sampling algorithm via angular measure
#'
#' This algorithm corresponds to Algorithm 1 in Dombry, Engelke and Oesting (2016),
#' using the formulation of the Dirichlet mixture of Coles and Tawn (1991)
#' as described and derived in Boldi (2009) for the bilogistic and extremal
#' Dirichlet model. Models currently implemented include logistic, negative
#' logistic, extremal Dirichlet and bilogistic MEV.
#'
#' @param n sample size
#' @param d dimension of the multivariate distribution
#' @param par a vector of parameters
#' @param model integer, currently ranging from 1 to 9, corresponding respectively to
#' (1) \code{log}, (2) \code{neglog}, (3) \code{dirmix}, (4) \code{bilog},
#' (5) \code{extstud}, (6) \code{br}, (7) \code{ct} and \code{sdir}, (8) \code{smith} and (9) \code{hr}.
#' @param Sigma covariance matrix for Brown-Resnick, Smith and extremal student. Conditionally negative definite
#' matrix of parameters for the Huesler--Reiss model. Default matrix for compatibility
#' @param loc matrix of location for Smith model.
#' @keywords internal
#' @return a \code{n} by \code{d} matrix containing the sample
.rmevA1 <- function(n, d, par, model, Sigma, loc) {
    .Call(`_mev_rmevA1`, n, d, par, model, Sigma, loc)
}

#' Multivariate extreme value distribution sampling algorithm via extremal functions
#'
#' Code implementing Algorithm 2 in Dombry, Engelke and Oesting (2016)
#'
#' @param n sample size
#' @param d dimension of the multivariate distribution
#' @param par a vector of parameters
#' @param model integer, currently ranging from 1 to 9, corresponding respectively to
#' (1) \code{log}, (2) \code{neglog}, (3) \code{dirmix}, (4) \code{bilog},
#' (5) \code{extstud}, (6) \code{br}, (7) \code{ct} and \code{sdir}, (8) \code{smith} and (9) \code{hr}.
#' @param Sigma covariance matrix for Brown-Resnick, Smith and extremal student. Default for compatibility
#' @param loc matrix of location for Smith model.
#' @keywords internal
#' @return a \code{n} by \code{d} matrix containing the sample
.rmevA2 <- function(n, d, par, model, Sigma, loc) {
    .Call(`_mev_rmevA2`, n, d, par, model, Sigma, loc)
}

#' Random sampling from spectral distribution on l1 sphere
#'
#' Generate from \eqn{Q_i}{Qi}, the spectral measure of a given multivariate extreme value model
#'
#' @param n sample size
#' @param d dimension of the multivariate distribution
#' @param par a vector of parameters
#' @param model integer, currently ranging from 1 to 9, corresponding respectively to
#' (1) \code{log}, (2) \code{neglog}, (3) \code{dirmix}, (4) \code{bilog},
#' (5) \code{extstud}, (6) \code{br}, (7) \code{ct} and \code{sdir}, (8) \code{smith} and (9) \code{hr}.
#' @param Sigma covariance matrix for Brown-Resnick and extremal student, symmetric matrix
#' of squared coefficients \eqn{\lambda^2} for Husler-Reiss. Default for compatibility
#' @param loc matrix of locations for the Smith model
#'
#' @references Dombry, Engelke and Oesting (2016). Exact simulation of max-stable processes,
#' \emph{Biometrika}, \bold{103}(2), 303--317.
#' @references Boldi (2009). A note on the representation of parametric models for multivariate extremes. \emph{Extremes} \bold{12}, 211--218.
#' @keywords internal
#' @return a \code{n} by \code{d} matrix containing the sample
.rmevspec_cpp <- function(n, d, par, model, Sigma, loc) {
    .Call(`_mev_rmevspec_cpp`, n, d, par, model, Sigma, loc)
}

#' Random samples from asymmetric logistic distribution
#'
#' Simulation algorithm of Stephenson (2003), using exact-samples from the logistic
#'
#' @param n sample size
#' @param d dimension of the multivariate distribution
#' @param par a vector of parameters
#' @param asym matrix of bool indicating which component belong to the corresponding row logistic model
#' @param ncompo number of components for the (negative) logistic in row
#' @param Sigma matrix of asymmetry parameters
#'
#' @references Stephenson, A. G. (2003) Simulating multivariate extreme value distributions of logistic type.
#' \emph{Extremes}, \bold{6}(1), 49--60.
#' @references Joe, H. (1990). Families of min-stable multivariate exponential and multivariate
#' extreme value distributions, \bold{9}, 75--81.
#' @keywords internal
#' @return a \code{n} by \code{d} matrix containing the sample
.rmevasy <- function(n, d, par, asym, ncompo, Sigma, model) {
    .Call(`_mev_rmevasy`, n, d, par, asym, ncompo, Sigma, model)
}

#' Samples from exceedances at site (scaled extremal function definition)
#'
#'
#' @param n sample size
#' @param j index of the site or variable
#' @param d dimension of the multivariate distribution
#' @param par a vector of parameters
#' @param model integer, currently ranging from 1 to 9, corresponding respectively to
#' (1) \code{log}, (2) \code{neglog}, (3) \code{dirmix}, (4) \code{bilog},
#' (5) \code{extstud}, (6) \code{br}, (7) \code{ct} and \code{sdir}, (8) \code{smith} and (9) \code{hr}.
#' @param Sigma covariance matrix for Brown-Resnick, Smith and extremal student. Default for compatibility
#' @param loc matrix of location for Smith model.
#' @keywords internal
#' @return a \code{n} by \code{d} matrix containing the sample
.rPsite <- function(n, j, d, par, model, Sigma, loc) {
    .Call(`_mev_rPsite`, n, j, d, par, model, Sigma, loc)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call(`_mev_RcppExport_registerCCallable`)
})
