% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rparpcs.R
\name{rparpcshr}
\alias{rparpcshr}
\title{Simulation of generalized Huesler-Reiss Pareto vectors via composition sampling}
\usage{
rparpcshr(n, u, alpha, Sigma, m)
}
\arguments{
\item{n}{sample size}

\item{u}{vector of marginal location parameters (must be strictly positive)}

\item{alpha}{vector of shape parameters (must be strictly positive).}

\item{Sigma}{covariance matrix of process, used to define \eqn{Q}. See \bold{Details}.}

\item{m}{location vector of Gaussian distribution.}
}
\value{
\code{n} by d matrix of observations
}
\description{
Sample from the generalized Pareto process associated to Huesler-Reiss spectral profiles.
For the Huesler-Reiss Pareto vectors, the matrix \code{Sigma} is utilized to build \eqn{Q} viz.
\deqn{Q = \Sigma^{-1} - \frac{\Sigma^{-1}\mathbf{1}_d\mathbf{1}_d^\top\Sigma^{-1}}{\mathbf{1}_d^\top\Sigma^{-1}\mathbf{1}_d}.}
The location vector \code{m} and \code{Sigma} are the parameters of the underlying log-Gaussian process.
}
\examples{
D <- 20L
coord <- cbind(runif(D), runif(D))
di <- as.matrix(dist(rbind(c(0, ncol(coord)), coord)))
semivario <- function(d, alpha = 1.5, lambda = 1){(d/lambda)^alpha}
Vmat <- semivario(di)
Sigma <- outer(Vmat[-1, 1], Vmat[1, -1], '+') - Vmat[-1, -1]
m <- Vmat[-1,1]
\dontrun{
samp <- rparpcshr(n = 100, u = c(rep(1, 10), rep(2, 10)),
          alpha = seq(0.1, 1, length = 20), Sigma = Sigma, m = m)
}
}
\references{
Ho, Z. W. O and C. Dombry (2017), Simple models for multivariate regular variations and the
  Huesler-Reiss Pareto distribution, \url{http://arxiv.org/abs/1712.09225v1}
}
