% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle.R
\name{gpd.mle}
\alias{gpd.mle}
\title{Generalized Pareto maximum likelihood estimates for various quantities of interest}
\usage{
gpd.mle(xdat, args = c("scale", "shape", "quant", "VaR", "ES", "Nmean",
  "Nquant"), m, N, p, q)
}
\arguments{
\item{xdat}{sample vector of excesses}

\item{args}{vector of strings indicating which arguments to return the maximum likelihood values for}

\item{m}{number of observations of interest for return levels. Required only for \code{args} values \code{'VaR'} or \code{'ES'}}

\item{N}{size of block over which to take maxima. Required only for \code{args} \code{Nmean} and \code{Nquant}.}

\item{p}{tail probability, equivalent to \eqn{1/m}. Required only for \code{args} \code{quant}.}

\item{q}{level of quantile for N-block maxima. Required only for \code{args} \code{Nquant}.}
}
\value{
named vector with maximum likelihood values for arguments \code{args}
}
\description{
This function calls the \code{fit.gpd} routine on the sample of excesses and returns maximum likelihood
estimates for all quantities of interest, including scale and shape parameters, quantiles and value-at-risk,
expected shortfall and mean and quantiles of maxima of \code{N} threshold exceedances
}
\examples{
xdat <- evd::rgpd(n = 30, shape = 0.2)
gpd.mle(xdat = xdat, N = 100, p = 0.01, q = 0.5, m = 100)
}
