% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penultimate.R
\name{egp.fit}
\alias{egp.fit}
\alias{egp.fitrange}
\title{Fit of extended GP models and parameter stability plots}
\usage{
egp.fit(xdat, thresh, model = c("egp1", "egp2", "egp3"), init)

egp.fitrange(xdat, thresh, model = c("egp1", "egp2", "egp3"), plots = 1:3,
  umin, umax, nint)
}
\arguments{
\item{xdat}{vector of observations, greater than the threshold}

\item{thresh}{threshold value}

\item{model}{a string indicating which extended family to fit}

\item{init}{vector of initial values, with \eqn{\log(\kappa)}{log(\kappa)} and \eqn{\log(\sigma)}{log(\sigma)}; can be omitted.}

\item{plots}{vector of integers specifying which parameter stability to plot (if any); passing \code{NA} results in no plots}

\item{umin}{optional minimum value considered for threshold (if \code{thresh} is not provided)}

\item{umax}{optional maximum value considered for threshold (if \code{thresh} is not provided)}

\item{nint}{optional integer number specifying the number of thresholds to test.}
}
\value{
\code{egp.fit} outputs the list returned by \link[stats]{optim}, which contains the parameter values, the hessian and in addition the standard errors

\code{egp.fitrange} returns a plot(s) of the parameters fit over the range of provided thresholds, with pointwise normal confidence intervals; the function also returns an invisible list containing notably the matrix of point estimates (\code{par}) and standard errors (\code{se}).
}
\description{
The function \code{egp.fitrange} provides classical parameter stability plot for (\eqn{\kappa}, \eqn{\sigma}, \eqn{\xi}). The fitted parameter values are displayed with pointwise normal 95\% confidence intervals.
 The plot is for the modified scale (as in the generalised Pareto model) and as such it is possible that the modified scale be negative.
\code{egp.fitrange} can also be used to fit the model to multiple thresholds.
}
\details{
\code{egp.fit} is a numerical optimization routine to fit the extended generalised Pareto models of Papastathopoulos and Tawn (2013),
using maximum likelihood estimation.
}
\references{
Papastathopoulos, I. and J. Tawn (2013). Extended generalised Pareto models for tail estimation, \emph{Journal of Statistical Planning and Inference} \bold{143}(3), 131--143.
}
\author{
Leo Belzile
}
