% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{confint.extprof}
\alias{confint.extprof}
\title{Confidence intervals for profile likelihood objects}
\usage{
\method{confint}{extprof}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{an object of class \code{extprof}, normally the output of \link{gpd.pll} or \link{gev.pll}.}

\item{parm}{a specification of which parameters are to be given confidence intervals,
either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{confidence level, with default 0.95}

\item{...}{additional arguments passed to functions. Providing a logical \code{warn=FALSE} turns off warning messages when the lower or upper confidence interval for \code{psi} are extrapolated beyond the provided calculations.}
}
\value{
a 2 by 3 matrix containing point estimates, lower and upper confidence intervals based on the likelihood root and modified version thereof
}
\description{
This function uses spline interpolation to derive \code{level} confidence intervals.
}
