% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dby.R
\name{dby}
\alias{dby}
\alias{dby2}
\alias{dby2<-}
\alias{dby<-}
\title{Calculate summary statistics grouped by}
\usage{
dby(data, INPUT, ..., ID = NULL, ORDER = NULL, SORT = 0,
  COMBINE = !REDUCE, NOCHECK = FALSE, ARGS = NULL, NAMES, FAST = TRUE,
  COLUMN = FALSE, REDUCE = FALSE, REGEX = mets.options()$regex)
}
\arguments{
\item{data}{Data.frame}

\item{INPUT}{Input variables (character or formula)}

\item{...}{functions}

\item{ID}{id variable}

\item{ORDER}{(optional) order variable}

\item{SORT}{sort order (id+order variable)}

\item{COMBINE}{If TRUE result is appended to data}

\item{NOCHECK}{No sorting or check for missing data}

\item{ARGS}{Optional list of arguments to functions (...)}

\item{NAMES}{Optional vector of column names}

\item{FAST}{if FALSE fallback to slower (safer) function evaluation}

\item{COLUMN}{If TRUE do the calculations for each column}

\item{REDUCE}{Reduce number of redundant rows}

\item{REGEX}{Allow regular expressions}
}
\description{
Calculate summary statistics grouped by variable
}
\details{
Calculate summary statistics grouped by

##' 
dby2 for column-wise calculations
}
\examples{
n <- 4
k <- c(3,rbinom(n-1,3,0.5)+1)
N <- sum(k)
d <- data.frame(y=rnorm(N),x=rnorm(N),id=rep(seq(n),k),num=unlist(sapply(k,seq)))
d2 <- d[sample(nrow(d)),]

dby(d, y~id, mean)
dby(d, y~id|num, cumsum)

dby(d,y~id|num, dlag, ARGS=list(k=1:2))

dby(d, y~id|num, dlag)
dby(d, y~id|num, y1=dlag, ARGS=list(k=1:2), NAMES=c("y1","y2"))
dby(d, y~id|num, mean=mean, csum=cumsum, n=length)
dby(d2,y~id|num, a=cumsum, b=mean, N=length, l1=function(x) c(NA,x)[-length(x)])

dby(d, y~id|num, nn=seq, n=length)

f <- function(x) apply(x,1,min)
dby(d, y+x~id, min=f)

dby(d,y+x~id|num, function(x) x)

f <- function(x) { cbind(cumsum(x[,1]),cumsum(x[,2]))/sum(x)}
dby(d, y+x~id, f)

# column-wise
a <- d
dby2(a, mean, median, REGEX=T) <- '^[y|x]'~id
a

}
\author{
Klaus K. Holst and Thomas Scheike
}

