% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recurrent.marginal.R
\name{prob.exceed.recurrent}
\alias{prob.exceed.recurrent}
\title{Estimation of probability of more that k events for recurrent events process}
\usage{
prob.exceed.recurrent(data, type, status = "status", death = "death",
  start = "start", stop = "stop", id = "id", times = NULL,
  exceed = NULL)
}
\arguments{
\item{data}{data-frame}

\item{type}{type of evnent (code) related to status}

\item{status}{name of status}

\item{death}{name of death indicator}

\item{start}{start stop call of Hist() of prodlim}

\item{stop}{start stop call of Hist() of prodlim}

\item{id}{id}

\item{times}{time at which to get probabilites P(N1(t) >= n)}

\item{exceed}{n's for which which to compute probabilites P(N1(t) >= n)}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Estimation of probability of more that k events for recurrent events process
where there is terminal event, based on this also estimate of variance of recurrent events.
}
\examples{
\donttest{
### do not test to avoid dependence on prodlim 
library(prodlim)

########################################
## getting some rates to mimick 
########################################

data(base1cumhaz)
data(base4cumhaz)
data(drcumhaz)
dr <- drcumhaz
base1 <- base1cumhaz
base4 <- base4cumhaz

cor.mat <- corM <- rbind(c(1.0, 0.6, 0.9), c(0.6, 1.0, 0.5), c(0.9, 0.5, 1.0))
rr <- simRecurrent(1000,base1,cumhaz2=base4,death.cumhaz=dr)
dtable(rr,~death+status)

pp <- prob.exceed.recurrent(rr,1,status="status",death="death",start="entry",stop="time",id="id")
with(pp, matplot(times,prob,type="s"))
###
with(pp, matlines(times,se.lower,type="s"))
with(pp, matlines(times,se.upper,type="s"))
}
}
\author{
Thomas Scheike
}
