% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{get_user_repo_list}
\alias{get_user_repo_list}
\title{Retrieve list of repositories for an organization}
\usage{
get_user_repo_list(
  owner,
  count = "all",
  data_format = "dataframe",
  token = NULL
)
}
\arguments{
\item{owner}{The owner of the repository. So for `https://github.com/fhdsl/metricminer`, it would be `fhdsl`}

\item{count}{The number of responses that should be returned. Default is 20 or you can say "all" to retrieve all.}

\item{data_format}{Default is to return a curated data frame. However if you'd like to see the raw information returned from GitHub set format to "raw".}

\item{token}{You can provide the Personal Access Token key directly or this function will attempt to grab a PAT that was stored using the `authorize("github")` function}
}
\value{
a list of repositories that an organization has
}
\description{
This is a function to get the information about a repository
}
\examples{
\dontrun{

authorize("github")
get_user_repo_list(owner = "metricminer")
}

}
