% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google-analytics.R
\name{get_all_ga_metrics}
\alias{get_all_ga_metrics}
\title{Get all metrics for all properties associated with an account}
\usage{
get_all_ga_metrics(account_id = NULL, token = NULL, dataformat = "dataframe")
}
\arguments{
\item{account_id}{the account id that you'd like to retrieve stats for all properties associated with it.}

\item{token}{credentials for access to Google using OAuth.  `authorize("google")`}

\item{dataformat}{How would you like the data returned to you? Default is a "dataframe" but if you'd like to see the original API list result, put "raw".}
}
\value{
Either a list of dataframes where `metrics`, `dimensions` and `link clicks` are reported. But if `format` is set to "raw" then the original raw API results will be returned

A list of metrics, dimensions, and link clicks for a for all properties underneath a Google Analytics account. It can be returned as a curated data.frame or the raw version which is the API response as a list
}
\description{
This is a function to gets metrics and dimensions for all properties associated with an account
}
\examples{
\dontrun{

authorize("google")
accounts <- get_ga_user()

some_stats_list <- get_all_ga_metrics(property_ids = property_ids)
}
}
