% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SpatialPixelsTopography-methods.R
\name{SpatialPixelsTopography}
\alias{SpatialPixelsTopography}
\title{Creates a 'SpatialPixelsTopography'}
\usage{
SpatialPixelsTopography(
  points,
  elevation,
  slope,
  aspect,
  tolerance = sqrt(.Machine$double.eps),
  proj4string = as.character(NA),
  round = NULL,
  grid = NULL
)
}
\arguments{
\item{points}{An object of class \code{SpatialPoints} or a
numeric matrix of coordinates.}

\item{elevation}{Elevation values (in m) of the points.}

\item{slope}{Slope values (in degrees) of the points.}

\item{aspect}{Aspect values (in degrees from North) of the points.}

\item{tolerance}{Precision up to which extent points should be exactly on a
grid.}

\item{proj4string}{Object of class \code{CRS} in the first
form only used when points does not inherit from
\code{Spatial}.}

\item{round}{default \code{NULL}, otherwise a value passed to as the digits
argument to \code{\link{round}} for setting cell size.}

\item{grid}{Grid topology using an object of class
\code{GridTopology}; a value of \code{NULL} implies that this
will be derived from the point coordinates.}
}
\value{
Function \code{SpatialPixelsTopography} returns an object
'\code{\link{SpatialPixelsTopography-class}}'.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Function \code{SpatialPixelsTopography} creates an object of class
\code{\link{SpatialPixelsTopography-class}} containing topographic variables
for a set of points.
}
\seealso{
\code{\link{SpatialPixelsTopography-class}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
