% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.coverage.R
\name{interpolation.coverage}
\alias{interpolation.coverage}
\title{Spatial and temporal coverage of interpolation data}
\usage{
interpolation.coverage(object, type = "spatial", percent = FALSE)
}
\arguments{
\item{object}{An object of class
\code{\link{MeteorologyInterpolationData-class}}.}

\item{type}{A string with the coverage summary to be produced (either
"spatial" or "temporal").}

\item{percent}{A boolean flag to indicate that percentages should be
returned instead of counts.}
}
\value{
If \code{type = "spatial"} the function returns an object of class
\code{SpatialPointsDataFrame} with the number (or percentage) of dates with
data per station and meteorological variable. If \code{type = "temporal"}
the function returns an object of class \code{data.frame} with the number
(or percentage) of stations with data per day and meteorological variable.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Function \code{interpolation.coverage} calculates, for each meteorological
variable, the number of stations with data per date or the number of dates
with data per station in an object of class
\code{\link{MeteorologyInterpolationData-class}}.
}
\examples{

data(exampleinterpolationdata)

#Number of days with data per station
head(interpolation.coverage(exampleinterpolationdata))

#Number of stations with data per day
head(interpolation.coverage(exampleinterpolationdata, type = "temporal"))

}
\references{
De Caceres M, Martin-StPaul N, Turco M, Cabon A, Granda V (2018)
Estimating daily meteorological data and downscaling climate models over
landscapes. Environmental Modelling and Software 108: 186-196.
}
\seealso{
\code{\link{MeteorologyInterpolationData}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
