% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfkindex.R
\name{lfkindex}
\alias{lfkindex}
\alias{print.lfkindex}
\title{LFK Index Test for Asymmetry}
\usage{
lfkindex(TE, seTE, data = NULL)

\method{print}{lfkindex}(x, digits = 2, ...)
}
\arguments{
\item{TE}{An object of class \code{meta} or estimated treatment
effect in individual studies.}

\item{seTE}{Standard error of estimated treatment effect (mandatory
if \code{TE} not of class \code{meta}).}

\item{data}{An optional data frame containing the study
information.}

\item{x}{An object of class \code{lfkindex}.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{\dots}{Additional arguments (ignored).}
}
\value{
An object of class \code{"lfkindex"} with corresponding
\code{print} function. The object is a list containing the
following components:

\item{lfkindex}{LFK index.}
\item{interpretation}{Interpretation of value of LFK index.}
\item{abs.zscore}{Absolute value of z-score.}
\item{N, MidRank, percentile, zscore}{Quantities used to calculate
  LFK index.}
\item{TE, seTE}{Estimated treatment effect, standard error.}
\item{version}{Version of R package metasens used to create
  object.}
}
\description{
Implementation of the LFK index test proposed by Furuya-Kanamori
et al. (2018) to evaluate bias in meta-analysis.
}
\examples{
# Example from Furuya-Kanamori et al. (2018)
#
pain <- data.frame(SMD = c(-4.270, -1.710, -0.580, -0.190, 0.000),
                   varSMD = c(0.158,  0.076,  0.018,  0.022, 0.040))

lfk.pain <- lfkindex(SMD, sqrt(varSMD), data = pain)
lfk.pain

doiplot(lfk.pain)

}
\references{
Furuya-Kanamori L, Barendregt JJ, Doi SAR (2018):
A new improved graphical and quantitative method for detecting bias
in meta-analysis.
\emph{International Journal of Evidence-Based Healthcare},
\bold{16}, 195--203
}
\seealso{
\code{\link{doiplot}}, \code{\link{metabias}},
  \code{\link{funnel.meta}}
}
\author{
Gerta Rücker \email{ruecker@imbi.uni-freiburg.de}, Guido
  Schwarzer \email{sc@imbi.uni-freiburg.de}
}
