% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gafem.R
\name{gafem}
\alias{gafem}
\title{Genotype analysis by fixed-effect models}
\usage{
gafem(.data, gen, rep, resp, prob = 0.05, block = NULL, verbose = TRUE)
}
\arguments{
\item{.data}{The dataset containing the columns related to, Genotypes,
replication/block and response variable(s).}

\item{gen}{The name of the column that contains the levels of the genotypes, that will
be treated as random effect.}

\item{rep}{The name of the column that contains the levels of the replications
(assumed to be fixed).}

\item{resp}{The response variable(s). To analyze multiple variables in a
single procedure a vector of variables may be used. For example \code{resp =
c(var1, var2, var3)}. Select helpers are also allowed.}

\item{prob}{The error probability. Defaults to 0.05.}

\item{block}{Defaults to \code{NULL}. In this case, a randomized complete
block design is considered. If block is informed, then a resolvable
alpha-lattice design (Patterson and Williams, 1976) is employed.
\strong{All effects, except the error, are assumed to be fixed.} Use the
function \code{\link{gamem}} to analyze a one-way trial with mixed-effect
models.}

\item{verbose}{Logical argument. If \code{verbose = FALSE} the code are run
silently.}
}
\value{
A list where each element is the result for one variable containing
the following objects:
\itemize{
\item \strong{anova:} The one-way ANOVA table.
\item \strong{model:} The model with of \code{lm}.
\item \strong{augment:} Information about each observation in the dataset. This
includes predicted values in the \code{fitted} column, residuals in the
\code{resid} column, standardized residuals in the \code{stdres} column,
the diagonal of the 'hat' matrix in the \code{hat}, and standard errors for
the fitted values in the \code{se.fit} column.
\item \strong{hsd:} The Tukey's 'Honest Significant Difference' for genotype
effect.
\item \strong{details:} A tibble with the following data: \code{Ngen}, the
number of genotypes; \code{OVmean}, the grand mean; \code{Min}, the minimum
observed (returning the genotype and replication/block); \code{Max} the
maximum observed, \code{MinGEN} the loser winner genotype, \code{MaxGEN},
the winner genotype.
}
}
\description{
One-way analysis of variance of genotypes conducted in both randomized
complete block and alpha-lattice designs.
}
\details{
\code{gafem} analyses data from a one-way genotype testing
experiment. By default, a randomized complete block design is used
according to the following model:
\loadmathjax
\mjsdeqn{Y_{ij} = m + g_i + r_j + e_{ij}}
where \mjseqn{Y_{ij}} is the response variable of the ith genotype in the
\emph{j}th block; \emph{m} is the grand mean (fixed); \mjseqn{g_i} is the effect
of the \emph{i}th genotype; \mjseqn{r_j} is the effect of the \emph{j}th
replicate; and \mjseqn{e_{ij}} is the random error.

When \code{block} is informed, then a resolvable alpha design is implemented,
according to the following model:

\mjsdeqn{Y_{ijk} = m + g_i + r_j + b_{jk} + e_{ijk}}
where where \mjseqn{y_{ijk}}
is the response variable of the \emph{i}th genotype in the \emph{k}th block
of the \emph{j}th replicate; \emph{m} is the intercept, \mjseqn{t_i} is the
effect for the \emph{i}th genotype \mjseqn{r_j} is the effect of the \emph{j}th
replicate, \mjseqn{b_{jk}} is the effect of the \emph{k}th incomplete block of
the \emph{j}th replicate, and \mjseqn{e_{ijk}} is the plot error effect
corresponding to \mjseqn{y_{ijk}}. All effects, except the random error are
assumed to be fixed.
}
\examples{
\donttest{
library(metan)
# RCBD
rcbd <- gafem(data_g,
             gen = GEN,
             rep = REP,
             resp = c(PH, ED, EL, CL, CW))

# Fitted values
get_model_data(rcbd)

# ALPHA-LATTICE DESIGN
alpha <- gafem(data_alpha,
              gen = GEN,
              rep = REP,
              block = BLOCK,
              resp = YIELD)

# Fitted values
get_model_data(alpha)

}

}
\references{
Patterson, H.D., and E.R. Williams. 1976. A new class of
resolvable incomplete block designs. Biometrika 63:83-92.
}
\seealso{
\code{\link{get_model_data}} \code{\link{gamem}}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
