% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{utils_stats}
\alias{utils_stats}
\alias{av_dev}
\alias{ci_mean}
\alias{cv}
\alias{freq_table}
\alias{hmean}
\alias{hm_mean}
\alias{gmean}
\alias{gm_mean}
\alias{kurt}
\alias{range_data}
\alias{sd_amo}
\alias{sd_pop}
\alias{sem}
\alias{skew}
\alias{sum_dev}
\alias{sum_sq_dev}
\alias{var_pop}
\alias{var_amo}
\alias{valid_n}
\alias{cv_by}
\alias{max_by}
\alias{means_by}
\alias{min_by}
\alias{n_by}
\alias{sd_by}
\alias{sem_by}
\title{Useful functions for computing descriptive statistics}
\usage{
av_dev(.data, ..., na.rm = FALSE)

ci_mean(.data, ..., na.rm = FALSE, level = 0.95)

cv(.data, ..., na.rm = FALSE)

freq_table(.data, ...)

hmean(.data, ..., na.rm = FALSE)

hm_mean(.data, ..., na.rm = FALSE)

gmean(.data, ..., na.rm = FALSE)

gm_mean(.data, ..., na.rm = FALSE)

kurt(.data, ..., na.rm = FALSE)

range_data(.data, ..., na.rm = FALSE)

sd_amo(.data, ..., na.rm = FALSE)

sd_pop(.data, ..., na.rm = FALSE)

sem(.data, ..., na.rm = FALSE)

skew(.data, ..., na.rm = FALSE)

sum_dev(.data, ..., na.rm = FALSE)

sum_sq_dev(.data, ..., na.rm = FALSE)

var_pop(.data, ..., na.rm = FALSE)

var_amo(.data, ..., na.rm = FALSE)

valid_n(.data, ..., na.rm = FALSE)

cv_by(.data, ..., na.rm = FALSE)

max_by(.data, ..., na.rm = FALSE)

means_by(.data, ..., na.rm = FALSE)

min_by(.data, ..., na.rm = FALSE)

n_by(.data, ..., na.rm = FALSE)

sd_by(.data, ..., na.rm = FALSE)

sem_by(.data, ..., na.rm = FALSE)
}
\arguments{
\item{.data}{A data frame or a numeric vector.}

\item{...}{The argument depends on the function used.
\itemize{
\item For \code{*_by} functions, \code{...} is one or more categorical variables
for grouping the data. Then the statistic required will be computed for all
numeric variables in the data. If no variables are informed in \code{...},
the statistic will be computed ignoring all non-numeric variables in
\code{.data}.
\item For the other statistics, \code{...} is a comma-separated of unquoted
variable names to compute the statistics. If no variables are informed in n
\code{...}, the statistic will be computed for all numeric variables in
\code{.data}.
}}

\item{na.rm}{A logical value indicating whether \code{NA} values should be
stripped before the computation proceeds. Defaults to \code{FALSE}.}

\item{level}{The confidence level for the confidence interval of the mean.
Defaults to 0.95.}
}
\value{
\itemize{
\item Functions \code{*_by()} returns a tbl_df with the computed statistics by
each level of the factor(s) declared in \code{...}.
\item All other functions return a nammed integer if the input is a data frame
or a numeric value if the input is a numeric vector.
}
}
\description{
\itemize{
\item \strong{The following functions compute descriptive statistics by levels of
a factor or combination of factors quickly.}
\itemize{
\item \code{cv_by()} For computing coefficient of variation.
\item \code{max_by()} For computing maximum values.
\item \code{means_by()} For computing arithmetic means.
\item \code{min_by()} For compuing minimum values.
\item \code{n_by()} For getting the length.
\item \code{sd_by()} For computing sample standard deviation.
\item \code{sem_by()} For computing standard error of the mean.
}
\item \strong{Useful functions for descriptive statistics. All of them work
naturally with \code{\%>\%}, handle grouped data and multiple variables (all
numeric variables from \code{.data} by default).}
\itemize{
\item \code{av_dev()} computes the average absolute deviation.
\item \code{ci_mean()} computes the confidence interval for the mean.
\item \code{cv()} computes the coefficient of variation.
\item \code{freq_table()} Computes frequency fable. Handles grouped data.
}
}
\itemize{
\item \code{hmean(), gmean()} computes the harmonic and geometric means,
respectively. The harmonic mean is the reciprocal of the arithmetic mean of
the reciprocals. The geometric mean is the \emph{n}th root of \emph{n}
products.
\itemize{
\item \code{kurt()} computes the kurtosis like used in SAS and SPSS.
\item \code{range_data()} Computes the range of the values.
\item \code{sd_amo(), sd_pop()} Computes sample and populational standard
deviation, respectively.
\item \code{sem()} computes the standard error of the mean.
\item \code{skew()} computes the skewness like used in SAS and SPSS.
\item \code{sum_dev()} computes the sum of the absolute deviations.
\item \code{sum_sq_dev()} computes the sum of the squared deviations.
\item \code{var_amo(), var_pop()} computes sample and populational variance.
\item \code{valid_n()} Return the valid (not \code{NA}) length of a data.
}
}

\code{\link{desc_stat}} is wrapper function around the above ones and can be
used to compute quickly all these statistics at once.
}
\examples{
\donttest{
library(metan)
# means of all numeric variables by ENV
means_by(data_ge2, GEN, ENV)

# Coefficient of variation for all numeric variables
# by GEN and ENV
cv_by(data_ge2, GEN, ENV)

# Skewness of a numeric vector
set.seed(1)
nvec <- rnorm(200, 10, 1)
skew(nvec)

# Confidence interval 0.95 for the mean
# All numeric variables
# Grouped by levels of ENV
data_ge2 \%>\%
  group_by(ENV) \%>\%
  ci_mean()

# standard error of the mean
# Variable PH and EH
sem(data_ge2, PH, EH)

# Frequency table for variable NR
data_ge2 \%>\%
  freq_table(NR)
}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
