% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.anova_ind.R
\name{print.anova_ind}
\alias{print.anova_ind}
\title{Print an object of class anova_ind}
\usage{
\method{print}{anova_ind}(x, export = FALSE, file.name = NULL, digits = 3, ...)
}
\arguments{
\item{x}{An object of class \code{anova_ind}.}

\item{export}{A logical argument. If \code{TRUE}, a *.txt file is exported to
the working directory.}

\item{file.name}{The name of the file if \code{export = TRUE}}

\item{digits}{The significant digits to be shown.}

\item{...}{Options used by the tibble package to format the output. See
\code{\link[tibble:formatting]{tibble::print()}} for more details.}
}
\description{
Print the \code{anova_ind} object in two ways. By default, the results are shown
in the R console. The results can also be exported to the directory into a
*.txt file.
}
\examples{

library(metan)
model <- data_ge \%>\% anova_ind(ENV, GEN, REP, c(GY, HM))
print(model)
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
