% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qe.study.level.R
\name{qe.study.level}
\alias{qe.study.level}
\title{Study-Level application of quantile estimation method}
\usage{
qe.study.level(min.g1, q1.g1, med.g1, q3.g1, max.g1, n.g1, mean.g1, sd.g1,
  min.g2, q1.g2, med.g2, q3.g2, max.g2, n.g2, mean.g2, sd.g2,
  single.family = FALSE, loc.shift = FALSE,
  qe.fit.control.g1 = list(), qe.fit.control.g2 = list())
}
\arguments{
\item{min.g1}{numeric value giving the sample minimum (first group for two-group studies).}

\item{q1.g1}{numeric value giving the first quartile (first group for two-group studies).}

\item{med.g1}{numeric value giving the sample median (first group for two-group studies).}

\item{q3.g1}{numeric value giving the sample third quartile (first group for two-group studies).}

\item{max.g1}{numeric value giving the sample maximum (first group for two-group studies).}

\item{n.g1}{numeric value giving the sample size (first group for two-group studies).}

\item{mean.g1}{numeric value giving the sample mean (first group for two-group studies).}

\item{sd.g1}{numeric value giving the sample standard deviation (first group for two-group studies).}

\item{min.g2}{numeric value giving the sample minimum of the second group for two-group studies.}

\item{q1.g2}{numeric value giving the sample first quartile of the second group for two-group studies.}

\item{med.g2}{numeric value giving the sample median of the second group for two-group studies.}

\item{q3.g2}{numeric value giving the sample third quartile of the second group for two-group studies.}

\item{max.g2}{numeric value giving the sample maximum of the second group for two-group studies.}

\item{n.g2}{numeric value giving the sample size of the second group for two-group studies.}

\item{mean.g2}{numeric value giving the sample mean of the second group for two-group studies.}

\item{sd.g2}{numeric value giving the sample standard deviation of the second group for two-group studies.}

\item{single.family}{logical scalar indicating that for two-group studies, the parametric family of distributions is assumed to be the same across both groups (the default is \code{FALSE}). See 'Details'.}

\item{loc.shift}{logical scalar indicating that for two-group studies, distributions are assumed to only differ by a location shift (the default is \code{FALSE}). See 'Details'.}

\item{qe.fit.control.g1}{optional list of control parameters for \code{\link{qe.fit}} (first group for two-group studies).}

\item{qe.fit.control.g2}{optional list of control parameters for \code{\link{qe.fit}} of the second group for two-group studies.}
}
\value{
A list with the following components:
\item{var}{Estimated sampling variance of the effect size.}
\item{effect.size}{Effect size of study.}
\item{selected.dist}{Selected outcome distribution(s). See 'Details'.}
\item{study.type}{Character string specifying whether one-group or two-group summary data was provided.}
}
\description{
This function estimates the asymptotic sampling variance of either the (estimated) median or the (estimated) difference of medians for a primary study that reports one of the following summary measures: \itemize{
\item S1: median, minimum and maximum values, and sample size
\item S2: median, first and third quartiles, and sample size
\item S3: median, minimum and maximum values, first and third quartiles, and sample size
\item S4: mean, standard deivation, and sample size.
 }.
}
\details{
In order to estimate the asymptotic sampling variance of the median, one must have an estimate of the probability density function of the outcome evaluated at the population median. When a study provides summary measures of S1, S2, or S3, the \code{\link{qe.fit}} function is applied to estimate the outcome distribution. When a study provides S4 summary measures, the outcome distribution is assumed to be normal and the parameters are fit by maximum likelihood estimation.

For two-group studies studies, one may assume that the outcome in both groups follows the same parametric family of distributions. In this case, distribution selection for the QE method is applied as follows. The \code{\link{qe.fit}} function is applied to fit the candidate distributions of each group separately. However, for each candidate distribution, the objective function evaluated at the fitting parameters are summed over the two groups. The parametric family of distributions with the smallest sum is used as the underlying distribution of the both groups. If \code{single.family} is \code{TRUE}, then \code{selected.dist} is a character string indicating the selected parametric family. If \code{single.family} is \code{FALSE}, then \code{selected.dist} is a vector of length 2 where elements 1 and 2 are character strings of the selected parametric families in groups 1 and 2, respectively.

One may also assume for two-group studies that the outcome distributions in the two groups only differ by a location shfit. In this case, a weighted mean (weighted by sample size) of the estimated probability density functions evaluated at the population medians is used to estimate the asymptotic sampling variance of the difference of medians. See McGrath et al. (2018) for further details.
}
\examples{
## Generate S2 summary data
set.seed(1)
n <- 100
x <- stats::rlnorm(n, 2.5, 1)
quants <- stats::quantile(x, probs = c(0.25, 0.5, 0.75))

## Estimate sampling variance of the median
qe.study.level(q1.g1 = quants[1], med.g1 = quants[2], q3.g1 = quants[3],
               n.g1 = n)

}
\references{
McGrath S., Sohn H., Steele R., and Benedetti A. (2018). Two-sample aggregate data meta-analysis of medians. \emph{ArXiv e-prints}. \url{https://arxiv.org/abs/1809.01278}.
}
