% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_d.R
\name{random_d}
\alias{random_d}
\title{Random generation of Hedges' d effect sizes.}
\usage{
random_d(K, X_t, var_t, N_t, X_c, var_c, N_c, bias_correction = TRUE)
}
\arguments{
\item{K}{Number of effect sizes to generate.}

\item{X_t}{The population mean (mu) of the (t)reatment group.}

\item{var_t}{The population variance of the treatment group mean.}

\item{N_t}{The number of samples of the treatment mean.  When a non-negative
integer, all treatment means will be estimated using the same N.  A
vector of unequal N's can also be taken; if so, K will be ignored and the 
number of randomly generated means will equal the length of that vector,
and each mean will be based on each N within the vector.}

\item{X_c}{The population mean (mu) of the (c)ontrol group.}

\item{var_c}{The population variance of the control group mean.}

\item{N_c}{The number of samples of the control mean.  When a non-negative
integer, all control means will be estimated using the same N.  A
vector of unequal N's can also be taken; if so, K will be ignored and the 
number of randomly generated means will equal the length of that vector,
and each mean will be based on each N within the vector.}

\item{bias_correction}{When \code{"FALSE"}, returns Cohen's g effect sizes 
that are not adjusted using a small-sample correction (J).}
}
\value{
A data table with columns of random effect sizes (d) and their 
   variances (var_d).
}
\description{
Generates random Hedges' d (1981, 1982) effect sizes and their variances.
}
\examples{
   random_d(K = 5, X_t = 25, var_t = 1, N_t = 15, X_c = 10, var_c = 1, N_c = 15)

}
\references{
Hedges, L.V. 1981. Distribution theory for Glass's estimator of 
   effect size and related estimators. Journal of Educational Statistics 
   6: 107-128.

Hedges, L.V. 1982. Estimation of effect size from a series of 
   independent experiments. Psychological Bulletin 92: 490-499.
}

