% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_PRISMA.R
\name{plot_PRISMA}
\alias{plot_PRISMA}
\title{Plots and creates a PRISMA flow diagram.}
\usage{
plot_PRISMA(aPhaseVector, colWidth = 30, excludeDistance = 0.8,
  hide = FALSE)
}
\arguments{
\item{aPhaseVector}{A vector of ordered labels (strings) for each phase of
the PRISMA diagram.  Labels designating the beginning of the diagram
are commented with "START_PHASE: " and those designating exclusion phases
"EXCLUDE_PHASE: ".  These comments will be removed from the diagram.}

\item{colWidth}{An optional value (integer) designating the width of the text 
box of each phase.}

\item{excludeDistance}{An optional value designating the the distance of 
exclude phase box from the main flow diagram.  Larger values (> 0.8) 
increase this distance.}

\item{hide}{When FALSE, the PRISMA flow diagram is not plotted.}
}
\value{
a grid object (grob) list
}
\description{
Creates a PRISMA (Preferred Reporting Items for Systematic Reviews and 
   Meta-Analyses) flow diagram depicting the 'flow' of study inclusions and
   exclusions during various systematic review phases.  It is meant to 
   describe the number of studies identified, included, excluded, reasons
   for inclusion/exclusions, and final number of studies used in the
   meta-analysis.  NOTE: currently only supports two start phases, and final
   phase must not have an exclude branch.
}
\examples{
phases <- c("START_PHASE: # of studies identified through database searching",
            "START_PHASE: # of additional studies identified through other sources",
            "# of studies after duplicates removed",
            "# of studies with title and abstract screened",
            "EXCLUDE_PHASE: # of studies excluded",
            "# of full-text articles assessed for eligibility",
            "EXCLUDE_PHASE: # of full-text excluded, not fitting eligibility criteria",
            "# of studies included in qualitative synthesis",
            "EXCLUDE_PHASE: # studies excluded, incomplete data reported",
            "final # of studies included in quantitative synthesis (meta-analysis)")
plot_PRISMA(phases)

}
\references{
Moher, D., Liberati, A., Tetzlaff, J. and Altman, D.G.,
   PRISMA Group. (2009) Preferred reporting items for systematic reviews and
   meta-analyses: the PRISMA statement. BMJ 339, b2535.
}

