% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/random_r.R
\name{random_r}
\alias{random_r}
\title{Random generation of correlation coefficients.}
\usage{
random_r(K = 100, correlation = 0.5, N = 10, Fisher_Z = FALSE)
}
\arguments{
\item{K}{Number of effect sizes to generate.}

\item{correlation}{The mean population correlation coefficient (rho) to
simulate.  Must range between -1 to 1.}

\item{N}{The number of samples used to estimate each correlation coefficient.
When a non-negative integer, all r will be estimated using the same N.  A
vector of unequal N's can also be taken; if so, K will be ignored and the
number of randomly generated r will equal the length of that vector.}

\item{Fisher_Z}{When \code{TRUE}, also returns the Fisher z-transformed
   correlation coefficients and their variances (Fisher 1915).}
}
\value{
A data table with columns of random effect sizes (r), their variances
   and sample sizes.
}
\description{
Generates random correlation coefficients (r or Pearson product-moment
correlation coefficients) and their variances (Pearson 1895).  Also provides
Fisher z-transformed correlation coefficients (Fisher 1915).
}
\examples{
random_r(K = 5, correlation = 0.5, N = 50)
}
\references{
Pearson, K. 1895. Notes on regression and inheritance in the
   case of two parents. Proceedings of the Royal Society of
   London 58: 240-242.

Fisher, R.A. 1915. Frequency distribution of the values of the
   correlation coefficient in samples of an indefinitely large
   population. Biometrika 10: 507-521.
}

