% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimaandpaths.R
\name{feprof.minima3d}
\alias{feprof.minima3d}
\title{Calculate free energy profile for minima3d object}
\usage{
\method{feprof}{minima3d}(minims, imax = NULL)
}
\arguments{
\item{minims}{minima3d object.}

\item{imax}{index of a hill from which summation stops (default the rest of hills).}
}
\description{
`feprof.minima3d` calculates free energy profiles for free energy minima.
It finds the global minimum at the `imax` and calculates the evolution of
free energies of a local vs. the global free energy minimum. The free
energy of the global minimum is constant (zero).
}
\examples{
library(metadynminer3d)
tfes<-fes(acealanme3d, imax=5000)
minima<-fesminima(tfes)
prof<-feprof(minima)
prof
}
