% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/re_permute.R
\name{permuteRE}
\alias{permuteRE}
\title{Permutation test}
\usage{
permuteRE(
  mf,
  nsplit,
  P = 999,
  sss,
  lookahead,
  minbucket = 3,
  minsplit = 6,
  cp = 1e-04,
  alpha.endcut = 0.02,
  a = 50,
  multi.start = T,
  n.starts = 3
)
}
\arguments{
\item{mf}{the data object of the RE-tree}

\item{nsplit}{the number of splits in the RE-tree}

\item{P}{the number of permuted data sets}

\item{sss}{boolean indicating whether the SSS strategy is used or not.}

\item{lookahead}{a boolean argument indicating whether to apply the "look-ahead" strategy when fitting the tree}

\item{minbucket}{the minimum number of observations in any terminal <leaf> node.}

\item{minsplit}{the minimum number of observations that must exist in a node in order for a split to be attempted.}

\item{cp}{complexity parameter as in rpart.}

\item{alpha.endcut}{parameter used in the splitting algorithm to avoid the endcut preference problem.}

\item{a}{parameter used in the sss to determine the slope of the logistic function that replaces the indicator function.}

\item{multi.start}{boolean indicating whether multiple starts must be used}

\item{n.starts}{number of multiple starts}
}
\value{
a vector of Q-between computed from the permuted data sets
}
\description{
Perform permutation test for an RE-tree
}
\keyword{internal}
