% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaGEplot.R
\name{metaGE.manhattan}
\alias{metaGE.manhattan}
\title{Draw the Manhattan plot.}
\usage{
metaGE.manhattan(
  Data,
  VarName,
  Threshold = NULL,
  SigZones = NULL,
  Score = FALSE,
  AnnotateMarker = NULL,
  Main = "",
  col = c("grey", "black"),
  colSigZones = "blue",
  Ylim = NULL
)
}
\arguments{
\item{Data}{A dataset containing the columns: CHR, POS, MARKER and the variable to plot for each marker, as obtained from metaGE.fit.}

\item{VarName}{The name of the column containing the variable to plot, generally the p-value or a score.}

\item{Threshold}{A threshold in order to draw a "genome-wide significant" line.  (optional)}

\item{SigZones}{A dataset containing the significant zones to plot, as obtained from metaGE.lscore. Must have columns: CHR, POS, START, END. (optional)}

\item{Score}{A boolean. If FALSE, the -log10 of the variable is plotted, useful for plotting p-values. If TRUE, the raw values of the variable is plotted, useful for plotting scores. (FALSE by default)}

\item{AnnotateMarker}{A list of markers name to annotate in the plot. (optional)}

\item{Main}{The main to display. (optional)}

\item{col}{A character vector indicating which colors to alternate for different chromosomes.(c('grey', 'black') by default)}

\item{colSigZones}{A character indicating which color to plot the significant zones.('blue' by default)}

\item{Ylim}{Two numeric values, specifying the lower limit and the upper limit of the  y-axe scale. (optional)}
}
\value{
The Manhattan plot
}
\description{
The function metaGE.manhattan displays the Manhattan plot of the -log10(p-value) or the local score of each marker along the genome.
}
\examples{
require(dplyr)
# Import the data
data("metaData")

# Compute the inter-environment correlation matrix
matCorr <- metaGE.cor(metaData, Threshold = 0.8)

# Fit the Fixed Effect model
FeDF <- metaGE.fit(metaData, matCorr, Method = "Fe")

# Control the FDR (here Benjamini-Hochberg)
Alpha <- 0.05
Signif <-  FeDF$PVALUE \%>\% p.adjust(method = "BH") \%>\% `<`(Alpha) \%>\% which

# Draw the corresponding manhattan plot
#PvalThresholdFe <- FeDF[Signif,]$PVALUE\%>\% max \%>\% max(.,0)
#manhattan_pval <- metaGE.manhattan(Data = FeDF,VarName = 'PVALUE',
#                             Threshold = PvalThresholdFe,
#                              Main = '-log10(Pval) alongside the chromosome Fe method')


# Compute the score local
xi <- 2
FeScore <- metaGE.lscore(FeDF,"PVALUE", xi)

# Draw the corresponding manhattan plot
manhattan_lscore <- metaGE.manhattan(Data = FeScore$Data,VarName = 'SCORE',
                                     SigZones = FeScore$SigZones, Score = TRUE,
                                     Main = 'Local score alongside the chromosome Fe method')




}
