% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.rm5.R
\name{summary.rm5}
\alias{summary.rm5}
\alias{summary.cdir}
\alias{print.summary.rm5}
\alias{print.summary.cdir}
\title{Cochrane review: detailed summary of meta-analyses}
\usage{
\method{summary}{rm5}(object, comp.no, outcome.no, ...)

\method{summary}{cdir}(object, comp.no, outcome.no, ...)

\method{print}{summary.rm5}(x, ...)

\method{print}{summary.cdir}(x, ...)
}
\arguments{
\item{object}{An object of class \code{rm5} or \code{cdir}.}

\item{comp.no}{Comparison number.}

\item{outcome.no}{Outcome number.}

\item{...}{Additional arguments (passed on to \code{metacr}).}

\item{x}{An object of class \code{summary.rm5} or
\code{summary.cdir}.}
}
\description{
Calculate and print a detailed summary of all meta-analyses in a
Cochrane review.
}
\details{
This function can be used to rerun all or selected meta-analyses of
a Cochrane Review of interventions (Higgins et al., 2023).

The R function \code{\link{metacr}} is called internally.
}
\examples{
# Locate export data file "Fleiss1993_CR.csv"
# in sub-directory of package "meta"
#
filename <- system.file("extdata", "Fleiss1993_CR.csv", package = "meta")
Fleiss1993_CR <- read.rm5(filename)

# Print summary results for all meta-analysis
#
summary(Fleiss1993_CR)

# Print summary results only for second outcome of first comparison
#
summary(Fleiss1993_CR, comp.no = 1, outcome.no = 2)

}
\references{
Higgins JPT, Thomas J, Chandler J, Cumpston M, Li T, Page MJ, Welch
VA (editors) (2023):
\emph{Cochrane Handbook for Systematic Reviews of Interventions
  Version 6.4 (updated August 2023)}.
Available from \url{https://training.cochrane.org/handbook/}
}
\seealso{
\code{\link{summary.meta}}, \code{\link{metacr}},
  \code{\link{read.rm5}}, \code{\link{read.cdir}},
  \code{\link{metabias.rm5}}, \code{\link{metabias.cdir}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
