% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.meta.R
\name{labels.meta}
\alias{labels.meta}
\title{Create study labels for forest plot}
\usage{
\method{labels}{meta}(
  object,
  author = object$studlab,
  year = "",
  citation = NULL,
  layout = "JAMA",
  data = object$data,
  ...
)
}
\arguments{
\item{object}{An object of class \code{meta}.}

\item{author}{An optional vector providing study authors.}

\item{year}{An optional vector providing year of publication.}

\item{citation}{An optional vector providing citation numbers.}

\item{layout}{A character string specifying layout. Either "JAMA"
or "Lancet".}

\item{data}{An optional data frame containing the study
information.}

\item{\dots}{Additional arguments (ignored at the moment).}
}
\description{
Create study labels for forest plot.
}
\details{
This auxiliary function can be used to create study labels in JAMA
or Lancet layout which can be added to a forest plot using argument
'studlab'.
}
\examples{
data(Fleiss1993bin)

refs <- 20 + 1:7

m <- metabin(d.asp, n.asp, d.plac, n.plac, data = Fleiss1993bin,
 studlab = study, sm = "OR", random = FALSE)

forest(m,
  studlab = labels(m, year = year, citation = refs, layout = "JAMA"),
  layout = "JAMA", fontfamily = "Times", fontsize = 10)

forest(m,
  studlab = labels(m, year = year, citation = refs, layout = "Lancet"))

}
\seealso{
\code{\link{forest.meta}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
