% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_adjlist}
\alias{get_adjlist}
\title{Get adjacency list}
\usage{
get_adjlist(adj)
}
\arguments{
\item{adj}{numeric matrix specifying the adjacency matrix.}
}
\value{
A list of vectors containing the indices of adjacent nodes.
}
\description{
Get list containing adjacent, i.e., neighboring, nodes for each node in the
graph. Nodes are returned as their row indices of the adjacency matrix.
}
\examples{

# generate watts strogatz graph
network = grow_ws(n = 6, k = 2, p = .5)

# transform to adjlist
get_adjlist(network)

}
