% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/memsurveillance.animated.R
\name{memsurveillance.animated}
\alias{memsurveillance.animated}
\title{Creates the animated surveillance graph of the current season}
\usage{
memsurveillance.animated(i.current, i.epidemic.thresholds = NA,
  i.intensity.thresholds = NA, i.output = ".", i.animated.graph.file = T,
  i.animated.graph.file.name = "animated", i.fps = 2, i.loop = 0,
  i.remove = T, ...)
}
\arguments{
\item{i.current}{Current season weekly rates.}

\item{i.epidemic.thresholds}{Pre and post epidemic threholds.}

\item{i.intensity.thresholds}{Intensity thresholds.}

\item{i.output}{Directory where graph is saved.}

\item{i.animated.graph.file}{If a animated gif should be produced, or just the intermediate graphics}

\item{i.animated.graph.file.name}{Name of the animated graph.}

\item{i.fps}{Number of frames per second of the animated gif.}

\item{i.loop}{Number of loops for the animated dif, 0 for Infinite.}

\item{i.remove}{Remove partial graphs.}

\item{...}{Additional parameters parsed to memsurveillance.}
}
\value{
\code{memsurveillance.animated} writes a gif graph of the surveillance of this season.
}
\description{
Function \code{memsurveillance.animated} creates an animated surveillance graph for the current season.
}
\details{
Input data must be the current season and an object of class \code{mem}. The output
graph contains the weekly rates series along with the epidemic and intensity threshols
located at the exact situation where the epidemic started. If there is no epidemic yet,
only the epidemic threshold is placed.
}
\examples{
# Castilla y Leon Influenza Rates data
data(flucyl)
# Data of the last season
cur<-flucyl[8]
# The model
epi<-memmodel(flucyl[1:7])
# Epidemic thresholds
e.thr<-epi$epidemic.thresholds
# Intensity threhsolds
i.thr<-epi$intensity.thresholds
# Set the working directory to whererever you want to store the graph file
setwd(".")
m1<-memsurveillance.animated(cur, i.animated.graph.file.name="Animated",
i.epidemic.thresholds = e.thr,i.intensity.thresholds = i.thr, i.pos.epidemic = TRUE,
i.animated.graph.file = FALSE)

}
\references{
Vega Alonso, Tomas, Jose E Lozano Alonso, Raul Ortiz de Lejarazu, and Marisol Gutierrez Perez. 2004.
Modelling Influenza Epidemic: Can We Detect the Beginning and Predict the Intensity and Duration?
International Congress Series, Options for the Control of Influenza V. Proceedings of the International
Conference on Options for the Control of Influenza V, 1263 (June): 281-83. doi:10.1016/j.ics.2004.02.121.\cr
Vega, Tomas, Jose Eugenio Lozano, Tamara Meerhoff, Rene Snacken, Joshua Mott, Raul Ortiz de Lejarazu, and
Baltazar Nunes. 2013. Influenza Surveillance in Europe: Establishing Epidemic Thresholds by the Moving
Epidemic Method. Influenza and Other Respiratory Viruses 7 (4): 546-58. doi:10.1111/j.1750-2659.2012.00422.x.\cr
Vega, Tomas, Jose E. Lozano, Tamara Meerhoff, Rene Snacken, Julien Beaute, Pernille Jorgensen, Raul Ortiz
de Lejarazu, et al. 2015. Influenza Surveillance in Europe: Comparing Intensity Levels Calculated Using
the Moving Epidemic Method. Influenza and Other Respiratory Viruses 9 (5): 234-46. doi:10.1111/irv.12330.
}
\author{
Jose E. Lozano \email{lozalojo@gmail.com}
}
\keyword{influenza}
