% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasErrorRandom.R
\name{MeasErrorRandom}
\alias{MeasErrorRandom}
\title{Create a Random Measurement Error Object}
\usage{
MeasErrorRandom(substitute, variance)
}
\arguments{
\item{substitute}{a vector containing the error-prone measure}

\item{variance}{a numeric quantifying the assumed variance of the random measurement error}
}
\value{
\code{MeasErrorRandom} returns an object of \link[base]{class}
"MeasErrorRandom".

An object of class \code{MeasErrorRandom} is a list containing the substitute
variable, the assumed variance of the random measurement error in that variable and, the
attributes input (the name of the substitute variable) and call (the matched
call).
}
\description{
This function creates a random measurement error object, usually used as
a covariate in the \code{formula} argument of \link[mecor]{mecor} if one
wants to correct for random measurement error in that variable
}
\examples{
## random measurement error in a covariate:
# internal covariate-validation study
data(icvs)
with(icvs, MeasErrorRandom(X_star, variance = 0.25))
}
\author{
Linda Nab, \email{l.nab@lumc.nl}
}
