/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.forms.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import multidendrograms.core.definitions.Dendrogram;
import multidendrograms.core.utils.SmartAxis;
import multidendrograms.definitions.Config;
import multidendrograms.definitions.Formats;
import multidendrograms.definitions.SettingsInfo;
import multidendrograms.forms.DendrogramParameters;
import multidendrograms.forms.children.FontSelection;
import multidendrograms.forms.panels.LoadUpdatePanel;
import multidendrograms.forms.panels.TreeOrientationPanel;
import multidendrograms.initial.InitialProperties;
import multidendrograms.initial.Language;
import multidendrograms.initial.LogManager;
import multidendrograms.types.DendrogramOrientation;
import multidendrograms.types.LabelOrientation;
import multidendrograms.types.MethodType;
import multidendrograms.types.OriginType;
import multidendrograms.types.ProximityType;

public class SettingsPanel
extends JPanel
implements ActionListener,
FocusListener,
InternalFrameListener {
    private static final long serialVersionUID = 1L;
    private static JLabel lblTypeMeasure;
    private static JLabel lblPrecision;
    private static JLabel lblMethod;
    private static JLabel lblMethodParameter;
    private static JLabel lblTreeTitle;
    private static JLabel lblTreeOrientation;
    private static JLabel lblNodesTitle;
    private static JLabel lblNodesOrientation;
    private static JLabel lblNodesSize;
    private static JLabel lblAxisTitle;
    private static JLabel lblAxisMin;
    private static JLabel lblAxisMax;
    private static JLabel lblAxisSeparation;
    private static JLabel lblAxisEvery;
    private static JLabel lblAxisTicks;
    private static JLabel lblAxisDecimals;
    private static JRadioButton rbDistances;
    private static JRadioButton rbSimilarities;
    private static JTextField txtPrecision;
    private static JComboBox cbMethod;
    private static JTextField txtMethodParameter;
    private static JComboBox cbTreeOrientation;
    private static JComboBox cbNodesSize;
    private static JComboBox cbNodesOrientation;
    private static JCheckBox chkBands;
    private static JCheckBox chkNodesLabels;
    private static JCheckBox chkAxis;
    private static JCheckBox chkAxisLabels;
    private static JCheckBox chkWeighted;
    private static JCheckBox chkUniformOrigin;
    private static JTextField txtAxisMin;
    private static JTextField txtAxisMax;
    private static JTextField txtAxisSeparation;
    private static JTextField txtAxisEvery;
    private static JTextField txtAxisDecimals;
    private static JButton btnColorBands;
    private static JButton btnFontNodes;
    private static JButton btnColorNodes;
    private static JButton btnFontAxisLabels;
    private static JButton btnColorAxis;
    private static JButton btnColorAxisLabels;
    private static Font fontNodesLabels;
    private static Font fontAxisLabels;
    private static Color colorBands;
    private static Color colorNodesLabels;
    private static Color colorAxis;
    private static Color colorAxisLabels;
    private TreeOrientationPanel pOrientationImg;

    public SettingsPanel() {
        this.createComponents();
        this.fillPanel();
    }

    private void createComponents() {
        lblTypeMeasure = Formats.getFormattedLabel(Language.getLabel(114) + " ");
        rbDistances = Formats.getFormattedRadioButton(Language.getLabel(27), true);
        rbSimilarities = Formats.getFormattedRadioButton(Language.getLabel(28), false);
        lblPrecision = Formats.getFormattedLabel(Language.getLabel(51) + " ");
        txtPrecision = Formats.getFormattedTextField("", 4, this.getLocale());
        lblMethod = Formats.getFormattedLabel(Language.getLabel(24) + " ");
        String[] stringArray = new String[]{"Versatile Linkage", "Single Linkage", "Complete Linkage", "Arithmetic Linkage", "Geometric Linkage", "Harmonic Linkage", "Centroid", "Ward", "Beta Flexible"};
        cbMethod = Formats.getFormattedComboBox(stringArray);
        cbMethod.setMaximumRowCount(stringArray.length);
        cbMethod.setSelectedItem("Arithmetic Linkage");
        String string = "<html><b>" + Language.getLabel(133) + ":</b><br>&nbsp;&nbsp;Arithmetic Linkage Unweighted = UPGMA = unweighted average<br>" + "&nbsp;&nbsp;Versatile Linkage (param 1.0) = Complete Linkage<br>" + "&nbsp;&nbsp;Versatile Linkage (param 0.1) = Arithmetic Linkage<br>" + "&nbsp;&nbsp;Versatile Linkage (param 0.0) = Geometric Linkage<br>" + "&nbsp;&nbsp;Versatile Linkage (param -0.1) = Harmonic Linkage<br>" + "&nbsp;&nbsp;Versatile Linkage (param -1.0) = Single Linkage<br>" + "&nbsp;&nbsp;Beta Flexible (param 0.0) = Arithmetic Linkage</html>";
        cbMethod.setToolTipText(string);
        lblMethodParameter = Formats.getFormattedLabel(Language.getLabel(53) + " ");
        txtMethodParameter = Formats.getFormattedTextField("", 4, this.getLocale());
        txtMethodParameter.setEnabled(false);
        chkWeighted = Formats.getFormattedCheckBox(Language.getLabel(63));
        chkWeighted.setSelected(InitialProperties.getWeighted());
        lblTreeTitle = Formats.getFormattedShadedTitleLabel(" " + Language.getLabel(29));
        lblTreeOrientation = Formats.getFormattedLabel(Language.getLabel(26) + " ");
        String[] stringArray2 = new String[]{Language.getLabel(88), Language.getLabel(89), Language.getLabel(90), Language.getLabel(91)};
        cbTreeOrientation = Formats.getFormattedComboBox(stringArray2);
        cbTreeOrientation.setSelectedItem(Language.getLabel(88));
        chkBands = Formats.getFormattedCheckBox(Language.getLabel(48));
        chkBands.setSelected(InitialProperties.getShowBands());
        colorBands = InitialProperties.getColorDendroBand();
        lblNodesTitle = Formats.getFormattedShadedTitleLabel(" " + Language.getLabel(30));
        lblNodesSize = Formats.getFormattedLabel(Language.getLabel(113) + " ");
        String[] stringArray3 = new String[]{"0", "2", "3", "4", "5", "6"};
        cbNodesSize = Formats.getFormattedComboBox(stringArray3);
        cbNodesSize.setSelectedItem("0");
        chkNodesLabels = Formats.getFormattedCheckBox(Language.getLabel(31));
        chkNodesLabels.setSelected(InitialProperties.getShowNodeLabels());
        fontNodesLabels = InitialProperties.getFontDendroNames();
        colorNodesLabels = InitialProperties.getColorDendroNames();
        lblNodesOrientation = Formats.getFormattedLabel(Language.getLabel(33) + " ");
        String[] stringArray4 = new String[]{Language.getLabel(94), Language.getLabel(92), Language.getLabel(93)};
        cbNodesOrientation = Formats.getFormattedComboBox(stringArray4);
        cbNodesOrientation.setSelectedItem(Language.getLabel(94));
        chkUniformOrigin = Formats.getFormattedCheckBox(Language.getLabel(132));
        chkUniformOrigin.setSelected(InitialProperties.getUniformOrigin());
        lblAxisTitle = Formats.getFormattedShadedTitleLabel(" " + Language.getLabel(36));
        chkAxis = Formats.getFormattedCheckBox(Language.getLabel(37));
        chkAxis.setSelected(InitialProperties.getShowAxis());
        colorAxis = InitialProperties.getColorDendroAxis();
        lblAxisMin = Formats.getFormattedLabel(Language.getLabel(41) + " ");
        txtAxisMin = Formats.getFormattedTextField("", 4, this.getLocale());
        lblAxisMax = Formats.getFormattedLabel(Language.getLabel(42) + " ");
        txtAxisMax = Formats.getFormattedTextField("", 4, this.getLocale());
        lblAxisSeparation = Formats.getFormattedLabel(Language.getLabel(43) + " ");
        txtAxisSeparation = Formats.getFormattedTextField("", 4, this.getLocale());
        chkAxisLabels = Formats.getFormattedCheckBox(Language.getLabel(39));
        chkAxisLabels.setSelected(InitialProperties.getShowAxisLabels());
        fontAxisLabels = InitialProperties.getFontDendroLabels();
        colorAxisLabels = InitialProperties.getColorDendroLabels();
        lblAxisEvery = Formats.getFormattedLabel(Language.getLabel(44));
        txtAxisEvery = Formats.getFormattedTextField("", 4, this.getLocale());
        lblAxisTicks = Formats.getFormattedLabel(" " + Language.getLabel(115));
        lblAxisDecimals = Formats.getFormattedLabel(Language.getLabel(49) + " ");
        txtAxisDecimals = Formats.getFormattedTextField("", 4, this.getLocale());
    }

    private void fillPanel() {
        this.setLayout(new GridBagLayout());
        this.setBorder(Formats.getFormattedTitledBorder(Language.getLabel(23)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(rbDistances);
        buttonGroup.add(rbSimilarities);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 1);
        this.add((Component)lblTypeMeasure, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)rbDistances, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 3);
        this.add((Component)rbSimilarities, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 1);
        this.add((Component)lblPrecision, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 3);
        txtPrecision.setName("precision");
        txtPrecision.addFocusListener(this);
        this.add((Component)txtPrecision, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 1);
        this.add((Component)lblMethod, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 3);
        cbMethod.setActionCommand("method");
        cbMethod.addActionListener(this);
        this.add((Component)cbMethod, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 1);
        this.add((Component)lblMethodParameter, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 3);
        txtMethodParameter.setName("method_parameter");
        txtMethodParameter.addFocusListener(this);
        this.add((Component)txtMethodParameter, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)chkWeighted, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)new JLabel(" "), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 3);
        this.add((Component)lblTreeTitle, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 1);
        this.add((Component)lblTreeOrientation, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        cbTreeOrientation.setActionCommand("dendro_orientation");
        cbTreeOrientation.addActionListener(this);
        this.add((Component)cbTreeOrientation, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.pOrientationImg = new TreeOrientationPanel();
        this.add((Component)this.pOrientationImg, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)chkBands, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        btnColorBands = Formats.getFormattedButton(Language.getLabel(35));
        btnColorBands.setActionCommand("color_bands");
        btnColorBands.addActionListener(this);
        this.add((Component)btnColorBands, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)new JLabel(" "), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 3);
        this.add((Component)lblNodesTitle, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 1);
        this.add((Component)lblNodesSize, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)cbNodesSize, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)chkNodesLabels, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        btnFontNodes = Formats.getFormattedButton(Language.getLabel(34));
        btnFontNodes.setActionCommand("font_nodes");
        btnFontNodes.addActionListener(this);
        this.add((Component)btnFontNodes, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 3);
        btnColorNodes = Formats.getFormattedButton(Language.getLabel(35));
        btnColorNodes.setActionCommand("color_nodes");
        btnColorNodes.addActionListener(this);
        this.add((Component)btnColorNodes, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 1);
        this.add((Component)lblNodesOrientation, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)cbNodesOrientation, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)chkUniformOrigin, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)new JLabel(" "), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 3);
        this.add((Component)lblAxisTitle, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)chkAxis, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        btnColorAxis = Formats.getFormattedButton(Language.getLabel(38));
        btnColorAxis.setActionCommand("color_axis");
        btnColorAxis.addActionListener(this);
        this.add((Component)btnColorAxis, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 1);
        this.add((Component)lblAxisMin, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        txtAxisMin.setName("axis_min");
        txtAxisMin.addFocusListener(this);
        this.add((Component)txtAxisMin, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 1);
        this.add((Component)lblAxisMax, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        txtAxisMax.setName("axis_max");
        txtAxisMax.addFocusListener(this);
        this.add((Component)txtAxisMax, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 1);
        this.add((Component)lblAxisSeparation, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        txtAxisSeparation.setName("axis_separation");
        txtAxisSeparation.addFocusListener(this);
        this.add((Component)txtAxisSeparation, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)chkAxisLabels, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        btnFontAxisLabels = Formats.getFormattedButton(Language.getLabel(45));
        btnFontAxisLabels.setActionCommand("font_axis");
        btnFontAxisLabels.addActionListener(this);
        this.add((Component)btnFontAxisLabels, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 3);
        btnColorAxisLabels = Formats.getFormattedButton(Language.getLabel(40));
        btnColorAxisLabels.setActionCommand("color_label");
        btnColorAxisLabels.addActionListener(this);
        this.add((Component)btnColorAxisLabels, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 1);
        this.add((Component)lblAxisEvery, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        txtAxisEvery.setName("axis_every");
        txtAxisEvery.addFocusListener(this);
        this.add((Component)txtAxisEvery, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.add((Component)lblAxisTicks, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 3, 1, 1);
        this.add((Component)lblAxisDecimals, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        txtAxisDecimals.setName("axis_decimals");
        txtAxisDecimals.addFocusListener(this);
        this.add((Component)txtAxisDecimals, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 1.0;
        JLabel jLabel = new JLabel();
        this.add((Component)jLabel, gridBagConstraints);
    }

    private Color changeColorFont(Color color) {
        Color color2 = JColorChooser.showDialog(null, Language.getLabel(1), color);
        if (color2 == null) {
            color2 = color;
        }
        return color2;
    }

    public static ProximityType getProximityType() {
        if (rbDistances.isSelected()) {
            return ProximityType.DISTANCE;
        }
        return ProximityType.SIMILARITY;
    }

    public static int getPrecision() {
        int n = -1;
        String string = txtPrecision.getText().trim();
        if (!string.equals("")) {
            try {
                n = Integer.parseInt(string);
                if (n < 0) {
                    n = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return n;
    }

    public static void setPrecision(int n) {
        txtPrecision.setText(String.valueOf(n));
        LoadUpdatePanel.precisionCorrect = true;
    }

    public static MethodType getMethod() {
        return MethodType.values()[cbMethod.getSelectedIndex()];
    }

    public static double getMethodParameter() {
        double d = 0.0;
        String string = txtMethodParameter.getText().trim();
        if (!string.equals("")) {
            try {
                d = Double.parseDouble(string);
                if (d < -1.0) {
                    d = -1.0;
                } else if (d > 1.0) {
                    d = 1.0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
            }
        }
        return d;
    }

    private static void setMethodParameter(MethodType methodType, double d) {
        if (methodType.equals((Object)MethodType.VERSATILE_LINKAGE) || methodType.equals((Object)MethodType.BETA_FLEXIBLE)) {
            Locale locale = new Locale("en");
            NumberFormat numberFormat = NumberFormat.getInstance(locale);
            numberFormat.setGroupingUsed(false);
            txtMethodParameter.setEnabled(true);
            txtMethodParameter.setText(numberFormat.format(d));
        } else {
            txtMethodParameter.setText("");
            txtMethodParameter.setEnabled(false);
        }
        LoadUpdatePanel.methodParameterCorrect = true;
    }

    public static boolean isWeighted() {
        return chkWeighted.isSelected();
    }

    private static double getMinValue() {
        double d = -1.0;
        String string = txtAxisMin.getText().trim();
        if (!string.equals("")) {
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                d = -1.0;
            }
        }
        return d;
    }

    private static void setMinValue(double d) {
        txtAxisMin.setText(String.valueOf(d));
        LoadUpdatePanel.axisMinCorrect = true;
    }

    private static double getMaxValue() {
        double d = -1.0;
        String string = txtAxisMax.getText().trim();
        if (!string.equals("")) {
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                d = -1.0;
            }
        }
        return d;
    }

    private static void setMaxValue(double d) {
        txtAxisMax.setText(String.valueOf(d));
        LoadUpdatePanel.axisMaxCorrect = true;
    }

    private static double getTicksSeparation() {
        double d = -1.0;
        String string = txtAxisSeparation.getText().trim();
        if (!string.equals("")) {
            try {
                d = Double.parseDouble(string);
                if (d <= 0.0) {
                    d = -1.0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                d = -1.0;
            }
        }
        return d;
    }

    private static void setTicksSeparation(double d) {
        Locale locale = new Locale("en");
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setGroupingUsed(false);
        txtAxisSeparation.setText(numberFormat.format(d));
        LoadUpdatePanel.axisSeparationCorrect = true;
    }

    private static int getLabelsEvery() {
        int n = -1;
        String string = txtAxisEvery.getText().trim();
        if (!string.equals("")) {
            try {
                n = Integer.parseInt(string);
                if (n < 0) {
                    n = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return n;
    }

    private static void setLabelsEvery(int n) {
        txtAxisEvery.setText(String.valueOf(n));
        LoadUpdatePanel.axisTicksCorrect = true;
    }

    private static int getLabelsDecimals() {
        int n = -1;
        String string = txtAxisDecimals.getText().trim();
        if (!string.equals("")) {
            try {
                n = Integer.parseInt(string);
                if (n < 0) {
                    n = -1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
        }
        return n;
    }

    private static void setLabelsDecimals(int n) {
        txtAxisDecimals.setText(String.valueOf(n));
        LoadUpdatePanel.axisDecimalsCorrect = true;
    }

    public static SettingsInfo getSettingsInfo() {
        SettingsInfo settingsInfo = new SettingsInfo();
        if (rbDistances.isSelected()) {
            settingsInfo.setSimilarityType(ProximityType.DISTANCE);
        } else {
            settingsInfo.setSimilarityType(ProximityType.SIMILARITY);
        }
        settingsInfo.setPrecision(SettingsPanel.getPrecision());
        settingsInfo.setMethod(MethodType.values()[cbMethod.getSelectedIndex()]);
        settingsInfo.setMethodParameter(SettingsPanel.getMethodParameter());
        settingsInfo.setWeighted(chkWeighted.isSelected());
        settingsInfo.setDendrogramOrientation(DendrogramOrientation.values()[cbTreeOrientation.getSelectedIndex()]);
        settingsInfo.setBandVisible(chkBands.isSelected());
        settingsInfo.setBandColor(colorBands);
        settingsInfo.setNodeNameVisible(chkNodesLabels.isSelected());
        settingsInfo.setNodeRadius(Integer.parseInt((String)cbNodesSize.getSelectedItem()));
        settingsInfo.setNodeNameOrientation(LabelOrientation.values()[cbNodesOrientation.getSelectedIndex()]);
        settingsInfo.setNodeNameFont(fontNodesLabels);
        settingsInfo.setNodeNameColor(colorNodesLabels);
        if (chkUniformOrigin.isSelected()) {
            settingsInfo.setOriginType(OriginType.UNIFORM_ORIGIN);
        } else {
            settingsInfo.setOriginType(OriginType.NON_UNIFORM_ORIGIN);
        }
        settingsInfo.setAxisVisible(chkAxis.isSelected());
        settingsInfo.setAxisLabelVisible(chkAxisLabels.isSelected());
        settingsInfo.setAxisColor(colorAxis);
        settingsInfo.setAxisLabelColor(colorAxisLabels);
        settingsInfo.setAxisLabelFont(fontAxisLabels);
        settingsInfo.setAxisMinValue(SettingsPanel.getMinValue());
        settingsInfo.setAxisMaxValue(SettingsPanel.getMaxValue());
        settingsInfo.setAxisIncrement(SettingsPanel.getTicksSeparation());
        settingsInfo.setAxisTicks(SettingsPanel.getLabelsEvery());
        settingsInfo.setAxisLabelDecimals(SettingsPanel.getLabelsDecimals());
        return settingsInfo;
    }

    public static void getConfigPanel(DendrogramParameters dendrogramParameters) {
        if (rbDistances.isSelected()) {
            dendrogramParameters.setProximityType(ProximityType.DISTANCE);
        } else {
            dendrogramParameters.setProximityType(ProximityType.SIMILARITY);
        }
        dendrogramParameters.setPrecision(SettingsPanel.getPrecision());
        dendrogramParameters.setMethod(MethodType.values()[cbMethod.getSelectedIndex()]);
        dendrogramParameters.setMethodParameter(SettingsPanel.getMethodParameter());
        dendrogramParameters.setWeighted(chkWeighted.isSelected());
        dendrogramParameters.setDendrogramOrientation(DendrogramOrientation.values()[cbTreeOrientation.getSelectedIndex()]);
        dendrogramParameters.setBandVisible(chkBands.isSelected());
        dendrogramParameters.setBandColor(colorBands);
        dendrogramParameters.setNodeRadius(Integer.parseInt((String)cbNodesSize.getSelectedItem()));
        dendrogramParameters.setNodeNameVisible(chkNodesLabels.isSelected());
        dendrogramParameters.setNodeNameFont(fontNodesLabels);
        dendrogramParameters.setNodeNameColor(colorNodesLabels);
        dendrogramParameters.setNodeNameOrientation(LabelOrientation.values()[cbNodesOrientation.getSelectedIndex()]);
        dendrogramParameters.setUniformOrigin(chkUniformOrigin.isSelected());
        dendrogramParameters.setAxisVisible(chkAxis.isSelected());
        dendrogramParameters.setAxisColor(colorAxis);
        dendrogramParameters.setAxisMinVal(SettingsPanel.getMinValue());
        dendrogramParameters.setAxisMaxVal(SettingsPanel.getMaxValue());
        dendrogramParameters.setAxisIncrement(SettingsPanel.getTicksSeparation());
        dendrogramParameters.setAxisLabelVisible(chkAxisLabels.isSelected());
        dendrogramParameters.setAxisLabelFont(fontAxisLabels);
        dendrogramParameters.setAxisLabelColor(colorAxisLabels);
        dendrogramParameters.setAxisTicks(SettingsPanel.getLabelsEvery());
        dendrogramParameters.setAxisLabelDecimals(SettingsPanel.getLabelsDecimals());
    }

    public static void setConfigPanel(DendrogramParameters dendrogramParameters) {
        rbDistances.setSelected(dendrogramParameters.getProximityType().equals((Object)ProximityType.DISTANCE));
        rbSimilarities.setSelected(dendrogramParameters.getProximityType().equals((Object)ProximityType.SIMILARITY));
        SettingsPanel.setPrecision(dendrogramParameters.getPrecision());
        MethodType methodType = dendrogramParameters.getMethod();
        cbMethod.setSelectedIndex(methodType.ordinal());
        SettingsPanel.setMethodParameter(methodType, dendrogramParameters.getMethodParameter());
        chkWeighted.setSelected(dendrogramParameters.isWeighted());
        cbTreeOrientation.setSelectedIndex(dendrogramParameters.getDendrogramOrientation().ordinal());
        chkBands.setSelected(dendrogramParameters.isBandVisible());
        colorBands = dendrogramParameters.getBandColor();
        cbNodesSize.setSelectedItem(Integer.toString(dendrogramParameters.getNodeRadius()));
        chkNodesLabels.setSelected(dendrogramParameters.isNodeNameVisible());
        cbNodesOrientation.setSelectedIndex(dendrogramParameters.getNodeNameOrientation().ordinal());
        fontNodesLabels = dendrogramParameters.getNodeNameFont();
        colorNodesLabels = dendrogramParameters.getNodeNameColor();
        chkUniformOrigin.setSelected(dendrogramParameters.isUniformOrigin());
        chkAxis.setSelected(dendrogramParameters.isAxisVisible());
        chkAxisLabels.setSelected(dendrogramParameters.isAxisLabelVisible());
        colorAxis = dendrogramParameters.getAxisColor();
        colorAxisLabels = dendrogramParameters.getAxisLabelColor();
        fontAxisLabels = dendrogramParameters.getAxisLabelFont();
        SettingsPanel.setMinValue(dendrogramParameters.getAxisMinVal());
        SettingsPanel.setMaxValue(dendrogramParameters.getAxisMaxVal());
        SettingsPanel.setTicksSeparation(dendrogramParameters.getAxisIncrement());
        SettingsPanel.setLabelsEvery(dendrogramParameters.getAxisTicks());
        SettingsPanel.setLabelsDecimals(dendrogramParameters.getAxisLabelDecimals());
    }

    public static void clearConfigPanel() {
        txtPrecision.setText("");
        LoadUpdatePanel.precisionCorrect = false;
        MethodType methodType = MethodType.values()[cbMethod.getSelectedIndex()];
        SettingsPanel.setMethodParameter(methodType, 0.0);
        txtAxisMin.setText("");
        LoadUpdatePanel.axisMinCorrect = false;
        txtAxisMax.setText("");
        LoadUpdatePanel.axisMaxCorrect = false;
        txtAxisSeparation.setText("");
        LoadUpdatePanel.axisSeparationCorrect = false;
        txtAxisEvery.setText("");
        LoadUpdatePanel.axisTicksCorrect = false;
        txtAxisDecimals.setText("");
        LoadUpdatePanel.axisDecimalsCorrect = false;
    }

    public static void adjustValues(Config config) {
        int n = config.getPrecision();
        SettingsPanel.setPrecision(n);
        SettingsInfo settingsInfo = config.getSettingsInfo();
        OriginType originType = settingsInfo.getOriginType();
        boolean bl = originType.equals((Object)OriginType.UNIFORM_ORIGIN);
        Dendrogram dendrogram = config.getRoot();
        SmartAxis smartAxis = new SmartAxis(dendrogram, bl);
        double d = smartAxis.smartMin();
        double d2 = smartAxis.smartMax();
        settingsInfo.setAxisMinValue(d);
        settingsInfo.setAxisMaxValue(d2);
        Locale locale = new Locale("en");
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        numberFormat.setGroupingUsed(false);
        txtAxisMin.setText(numberFormat.format(d));
        LoadUpdatePanel.axisMinCorrect = true;
        txtAxisMax.setText(numberFormat.format(d2));
        LoadUpdatePanel.axisMaxCorrect = true;
        double d3 = smartAxis.smartTicksSize();
        SettingsPanel.setTicksSeparation(d3);
        SettingsPanel.setLabelsEvery(1);
        SettingsPanel.setLabelsDecimals(n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("method")) {
            MethodType methodType = MethodType.values()[cbMethod.getSelectedIndex()];
            SettingsPanel.setMethodParameter(methodType, 0.0);
        } else if (actionEvent.getActionCommand().equals("dendro_orientation")) {
            this.pOrientationImg.setImage(DendrogramOrientation.values()[cbTreeOrientation.getSelectedIndex()]);
        } else if (actionEvent.getActionCommand().equals("color_bands")) {
            colorBands = this.changeColorFont(colorBands);
        } else if (actionEvent.getActionCommand().equals("font_nodes")) {
            FontSelection fontSelection = new FontSelection(fontNodesLabels);
            fontSelection.setVisible(true);
            fontNodesLabels = fontSelection.getNewFont();
        } else if (actionEvent.getActionCommand().equals("color_nodes")) {
            colorNodesLabels = this.changeColorFont(colorNodesLabels);
        } else if (actionEvent.getActionCommand().equals("color_axis")) {
            colorAxis = this.changeColorFont(colorAxis);
        } else if (actionEvent.getActionCommand().equals("font_axis")) {
            FontSelection fontSelection = new FontSelection(fontAxisLabels);
            fontSelection.setVisible(true);
            fontAxisLabels = fontSelection.getNewFont();
        } else if (actionEvent.getActionCommand().equals("color_label")) {
            colorAxisLabels = this.changeColorFont(colorAxisLabels);
        } else {
            LogManager.LOG.warning(Language.getLabel(47) + ": " + actionEvent.toString());
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            if (focusEvent.getComponent().getName().equals("precision")) {
                LoadUpdatePanel.precisionCorrect = this.checkPrecision();
            } else if (focusEvent.getComponent().getName().equals("method_parameter")) {
                LoadUpdatePanel.methodParameterCorrect = this.checkMethodParameter();
            } else if (focusEvent.getComponent().getName().equals("axis_min")) {
                LoadUpdatePanel.axisMinCorrect = this.checkMinValue();
            } else if (focusEvent.getComponent().getName().equals("axis_max")) {
                LoadUpdatePanel.axisMaxCorrect = this.checkMaxValue();
            } else if (focusEvent.getComponent().getName().equals("axis_separation")) {
                LoadUpdatePanel.axisSeparationCorrect = this.checkTicksSeparation();
            } else if (focusEvent.getComponent().getName().equals("axis_every")) {
                LoadUpdatePanel.axisTicksCorrect = this.checkLabelsEvery();
            } else if (focusEvent.getComponent().getName().equals("axis_decimals")) {
                LoadUpdatePanel.axisDecimalsCorrect = this.checkLabelsDecimals();
            }
            LoadUpdatePanel.enableUpdate();
        }
    }

    private boolean checkPrecision() {
        boolean bl = true;
        String string = txtPrecision.getText().trim();
        if (string.equals("")) {
            bl = false;
            SettingsPanel.showError(Language.getLabel(2));
        } else {
            try {
                int n = Integer.parseInt(string);
                if (n < 0) {
                    bl = false;
                    SettingsPanel.showError(Language.getLabel(2));
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                SettingsPanel.showError(Language.getLabel(2));
            }
        }
        return bl;
    }

    private boolean checkMethodParameter() {
        boolean bl = true;
        String string = txtMethodParameter.getText().trim();
        if (string.equals("")) {
            bl = false;
            SettingsPanel.showError(Language.getLabel(68));
        } else {
            try {
                double d = Double.parseDouble(string);
                if (d < -1.0 || 1.0 < d) {
                    bl = false;
                    SettingsPanel.showError(Language.getLabel(68));
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                SettingsPanel.showError(Language.getLabel(68));
            }
        }
        return bl;
    }

    private boolean checkMinValue() {
        boolean bl = true;
        String string = txtAxisMin.getText().trim();
        if (string.equals("")) {
            bl = false;
            SettingsPanel.showError(Language.getLabel(3));
        } else {
            try {
                double d = Double.parseDouble(string);
                if (d > SettingsPanel.getMaxValue()) {
                    bl = false;
                    SettingsPanel.showError(Language.getLabel(19));
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                SettingsPanel.showError(Language.getLabel(3));
            }
        }
        return bl;
    }

    private boolean checkMaxValue() {
        boolean bl = true;
        String string = txtAxisMax.getText().trim();
        if (string.equals("")) {
            bl = false;
            SettingsPanel.showError(Language.getLabel(4));
        } else {
            try {
                double d = Double.parseDouble(string);
                if (d < SettingsPanel.getMinValue()) {
                    bl = false;
                    SettingsPanel.showError(Language.getLabel(19));
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                SettingsPanel.showError(Language.getLabel(4));
            }
        }
        return bl;
    }

    private boolean checkTicksSeparation() {
        boolean bl = true;
        String string = txtAxisSeparation.getText().trim();
        if (string.equals("")) {
            bl = false;
            SettingsPanel.showError(Language.getLabel(5));
        } else {
            try {
                double d = Double.parseDouble(string);
                if (d <= 0.0) {
                    bl = false;
                    SettingsPanel.showError(Language.getLabel(5));
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                SettingsPanel.showError(Language.getLabel(5));
            }
        }
        return bl;
    }

    private boolean checkLabelsEvery() {
        boolean bl = true;
        String string = txtAxisEvery.getText().trim();
        if (string.equals("")) {
            bl = false;
            SettingsPanel.showError(Language.getLabel(6));
        } else {
            try {
                int n = Integer.parseInt(string);
                if (n < 0) {
                    bl = false;
                    SettingsPanel.showError(Language.getLabel(6));
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                SettingsPanel.showError(Language.getLabel(6));
            }
        }
        return bl;
    }

    private boolean checkLabelsDecimals() {
        boolean bl = true;
        String string = txtAxisDecimals.getText().trim();
        if (string.equals("")) {
            bl = false;
            SettingsPanel.showError(Language.getLabel(50));
        } else {
            try {
                int n = Integer.parseInt(string);
                if (n < 0) {
                    bl = false;
                    SettingsPanel.showError(Language.getLabel(50));
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                SettingsPanel.showError(Language.getLabel(50));
            }
        }
        return bl;
    }

    private static void showError(String string) {
        JOptionPane.showMessageDialog(null, string, Language.getLabel(7), 0);
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
    }
}

