/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.forms;

import java.awt.Color;
import java.awt.Font;
import javax.swing.JOptionPane;
import multidendrograms.core.clusterings.HierarchicalClustering;
import multidendrograms.data.ExternalData;
import multidendrograms.dendrogram.UltrametricMatrix;
import multidendrograms.forms.panels.SettingsPanel;
import multidendrograms.initial.Language;
import multidendrograms.types.DendrogramOrientation;
import multidendrograms.types.LabelOrientation;
import multidendrograms.types.MethodType;
import multidendrograms.types.ProximityType;

public class DendrogramParameters {
    private ExternalData externalData;
    private HierarchicalClustering clustering = null;
    private UltrametricMatrix ultraMatrix = null;
    private ProximityType proximityType;
    private int precision;
    private MethodType method;
    private double methodParameter;
    private boolean weighted = false;
    private DendrogramOrientation dendroOrientation = DendrogramOrientation.NORTH;
    private boolean bandVisible = true;
    private Color bandColor = Color.LIGHT_GRAY;
    private int nodeRadius = 0;
    private boolean nodeNameVisible = true;
    private Font nodeNameFont;
    private Color nodeNameColor;
    private LabelOrientation nodeNameOrientation = LabelOrientation.VERTICAL;
    private boolean uniformOrigin = true;
    private boolean axisVisible = true;
    private Color axisColor = Color.BLACK;
    private double axisMinVal = 0.0;
    private double axisMaxVal = 1.0;
    private double axisIncrement = 0.1;
    private int axisTicks = 10;
    private boolean axisLabelVisible = true;
    private Font axisLabelFont;
    private Color axisLabelColor = Color.BLACK;
    private int axisLabelDecimals = 0;

    public DendrogramParameters(ExternalData externalData, HierarchicalClustering hierarchicalClustering) {
        try {
            this.externalData = externalData;
            this.clustering = hierarchicalClustering;
            SettingsPanel.getConfigPanel(this);
        }
        catch (Exception exception) {
            this.showError("Error: \n" + exception.toString());
        }
    }

    public HierarchicalClustering getHierarchicalClustering() {
        return this.clustering;
    }

    public UltrametricMatrix getUltrametricMatrix() {
        return this.ultraMatrix;
    }

    public void setUltrametricMatrix(UltrametricMatrix ultrametricMatrix) {
        this.ultraMatrix = ultrametricMatrix;
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(null, string, Language.getLabel(7), 0);
    }

    public ExternalData getExternalData() {
        return this.externalData;
    }

    public ProximityType getProximityType() {
        return this.proximityType;
    }

    public void setProximityType(ProximityType proximityType) {
        this.proximityType = proximityType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public MethodType getMethod() {
        return this.method;
    }

    public void setMethod(MethodType methodType) {
        this.method = methodType;
    }

    public double getMethodParameter() {
        return this.methodParameter;
    }

    public void setMethodParameter(double d) {
        this.methodParameter = d;
    }

    public boolean isWeighted() {
        return this.weighted;
    }

    public void setWeighted(boolean bl) {
        this.weighted = bl;
    }

    public DendrogramOrientation getDendrogramOrientation() {
        return this.dendroOrientation;
    }

    public void setDendrogramOrientation(DendrogramOrientation dendrogramOrientation) {
        this.dendroOrientation = dendrogramOrientation;
    }

    public boolean isBandVisible() {
        return this.bandVisible;
    }

    public void setBandVisible(boolean bl) {
        this.bandVisible = bl;
    }

    public Color getBandColor() {
        return this.bandColor;
    }

    public void setBandColor(Color color) {
        this.bandColor = color;
    }

    public int getNodeRadius() {
        return this.nodeRadius;
    }

    public void setNodeRadius(int n) {
        this.nodeRadius = n;
    }

    public boolean isNodeNameVisible() {
        return this.nodeNameVisible;
    }

    public void setNodeNameVisible(boolean bl) {
        this.nodeNameVisible = bl;
    }

    public Font getNodeNameFont() {
        return this.nodeNameFont;
    }

    public void setNodeNameFont(Font font) {
        this.nodeNameFont = font;
    }

    public Color getNodeNameColor() {
        return this.nodeNameColor;
    }

    public void setNodeNameColor(Color color) {
        this.nodeNameColor = color;
    }

    public LabelOrientation getNodeNameOrientation() {
        return this.nodeNameOrientation;
    }

    public void setNodeNameOrientation(LabelOrientation labelOrientation) {
        this.nodeNameOrientation = labelOrientation;
    }

    public boolean isUniformOrigin() {
        return this.uniformOrigin;
    }

    public void setUniformOrigin(boolean bl) {
        this.uniformOrigin = bl;
    }

    public boolean isAxisVisible() {
        return this.axisVisible;
    }

    public void setAxisVisible(boolean bl) {
        this.axisVisible = bl;
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public void setAxisColor(Color color) {
        this.axisColor = color;
    }

    public double getAxisMinVal() {
        return this.axisMinVal;
    }

    public void setAxisMinVal(double d) {
        this.axisMinVal = d;
    }

    public double getAxisMaxVal() {
        return this.axisMaxVal;
    }

    public void setAxisMaxVal(double d) {
        this.axisMaxVal = d;
    }

    public double getAxisIncrement() {
        return this.axisIncrement;
    }

    public void setAxisIncrement(double d) {
        this.axisIncrement = d;
    }

    public int getAxisTicks() {
        return this.axisTicks;
    }

    public void setAxisTicks(int n) {
        this.axisTicks = n;
    }

    public boolean isAxisLabelVisible() {
        return this.axisLabelVisible;
    }

    public void setAxisLabelVisible(boolean bl) {
        this.axisLabelVisible = bl;
    }

    public Font getAxisLabelFont() {
        return this.axisLabelFont;
    }

    public void setAxisLabelFont(Font font) {
        this.axisLabelFont = font;
    }

    public Color getAxisLabelColor() {
        return this.axisLabelColor;
    }

    public void setAxisLabelColor(Color color) {
        this.axisLabelColor = color;
    }

    public int getAxisLabelDecimals() {
        return this.axisLabelDecimals;
    }

    public void setAxisLabelDecimals(int n) {
        this.axisLabelDecimals = n;
    }
}

