/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram;

import multidendrograms.definitions.BoxContainer;
import multidendrograms.definitions.Coordinates;
import multidendrograms.types.DendrogramOrientation;

public class Scaling {
    private double screenOriginX;
    private double screenOriginY;
    private double screenWidth;
    private double screenHeight;
    private double worldMinX;
    private double worldMaxX;
    private double worldMinY;
    private double worldMaxY;

    public Scaling(double d, double d2, double d3, double d4, double d5, double d6) {
        this.screenOriginX = 0.0;
        this.screenOriginY = 0.0;
        this.screenWidth = d5;
        this.screenHeight = d6;
        this.worldMinX = d3;
        this.worldMaxX = d;
        this.worldMinY = d4;
        this.worldMaxY = d2;
    }

    public Scaling(BoxContainer boxContainer) {
        this.screenOriginX = boxContainer.getCornerX();
        this.screenOriginY = boxContainer.getCornerY();
        this.screenWidth = boxContainer.getWidth();
        this.screenHeight = boxContainer.getHeight();
        this.worldMinX = boxContainer.getValMinX();
        this.worldMaxX = boxContainer.getValMaxX();
        this.worldMinY = boxContainer.getValMinY();
        this.worldMaxY = boxContainer.getValMaxY();
    }

    public void setWidth(double d) {
        this.screenWidth = d;
    }

    public double getWidth() {
        return this.screenWidth;
    }

    public void setHeight(double d) {
        this.screenHeight = d;
    }

    public double getHeight() {
        return this.screenHeight;
    }

    public double getValuesWidth() {
        return this.worldMaxX - this.worldMinX;
    }

    public double getValuesHeight() {
        return this.worldMaxY - this.worldMinY;
    }

    public double getMinX() {
        return this.worldMinX;
    }

    public double getMaxX() {
        return this.worldMaxX;
    }

    public double getMinY() {
        return this.worldMinY;
    }

    public double getMaxY() {
        return this.worldMaxY;
    }

    public double scaleX(double d) {
        return this.screenWidth * (d - this.worldMinX) / (this.worldMaxX - this.worldMinX);
    }

    public double scaleY(double d) {
        return this.screenHeight * (d - this.worldMinY) / (this.worldMaxY - this.worldMinY);
    }

    public double transformX(double d) {
        return this.screenOriginX + this.scaleX(d);
    }

    public double transformY(double d) {
        return this.screenOriginY + this.scaleY(d);
    }

    public Coordinates<Double> transform(Coordinates<Double> coordinates, DendrogramOrientation dendrogramOrientation) {
        double d;
        double d2 = coordinates.getX();
        double d3 = coordinates.getY();
        if (dendrogramOrientation == DendrogramOrientation.EAST) {
            d = d3;
            d3 = this.worldMaxY - d2;
            d2 = d;
        } else if (dendrogramOrientation == DendrogramOrientation.WEST) {
            d = this.worldMaxY - d2;
            d2 = this.worldMinX + (this.worldMaxX - d3);
            d3 = d;
        } else if (dendrogramOrientation == DendrogramOrientation.SOUTH) {
            d3 = this.worldMinY + (this.worldMaxY - d3);
        }
        d = this.transformX(d2);
        double d4 = this.transformY(d3);
        Coordinates<Double> coordinates2 = new Coordinates<Double>(d, d4);
        return coordinates2;
    }
}

