% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_id_raster.R
\name{values_to_raster}
\alias{values_to_raster}
\title{Insert values into a raster}
\usage{
values_to_raster(x, id_raster)
}
\arguments{
\item{x}{Vector, matrix, data.frame, or data.table of values that will be inserted into
the ID raster. The length of x must be exactly divisible by
\code{sum(!is.na(terra::values(id_raster)))}. Data.frames are converted to matrices, and
then matrices are converted to vectors using \code{\link[=as.matrix]{as.matrix()}} and \code{\link[=as.vector]{as.vector()}}
respectively before processing. For that reason, data.frames should only contain
fields with values to be inserted (such as a data.frame of draws).}

\item{id_raster}{ID raster showing the outline of the study area, created using
\code{\link[=build_id_raster]{build_id_raster()}}. Should have 1 layer.}
}
\value{
SpatRaster with the same outline as the ID raster and (# values / # non-NA
pixels in the ID raster) layers.
}
\description{
Insert a vector or matrix of values into an ID spatRaster
}
\details{
The length of the vector or matrix must be a multiple of the number of non-NA
pixels in the ID raster. Values from the vector/matrix are then inserted into the
non-NA pixels of the spatRaster.
}
\examples{
# Example ID raster with 10 rows and 10 columns, and 99 valid pixels
example_id_raster <- terra::rast(matrix(c(seq_len(99), NA), nrow = 10))
# Inserting 99 values yields a spatRaster with 1 layer
mbg::values_to_raster(stats::rnorm(99), example_id_raster)
# Inserting 99 * 3 values yields a spatRaster with 3 layers
mbg::values_to_raster(seq_len(99 * 3), example_id_raster)
# Trying to insert values with length not divisible by 99 yields an error
try(mbg::values_to_raster(seq_len(100), example_id_raster))

}
\seealso{
\code{\link[=build_id_raster]{build_id_raster()}}
}
\concept{prediction}
