% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mazeAbility.R
\name{mazeAbility}
\alias{mazeAbility}
\title{mazeAbility}
\usage{
mazeAbility(nodePosition, dot = 2, model = "t2")
}
\arguments{
\item{nodePosition}{You need to calculate the nodePosition.}

\item{dot}{This is the number of black dots.}

\item{model}{There are 4 models to estimate ability (t1,t2,t3,t4).}
}
\value{
An 'ab' class is created which will be used for other functions in the package.
}
\description{
The ability function returns the weighted score of the individual given his raw score (i.e. the number of black dotes collected).
}
\details{
This function calculates the weighted score of the participant given the number of dots collected. The function adopts 4 different models which follows the Davies & Davies (1965) paper. The formula for is Model 1:

\deqn{log(2^{R}/U_{m})}

where \eqn{2^R} is the total number of paths and \eqn{U_{m}} is the paths through the specified number of dots. The formula for Model 2:

\deqn{U_{\hat{m}}/U_{m})}

where \eqn{U_{\hat{m}}} is the value with the maximum number of connected dots. The formula for Model 3:

 \deqn{log(2^{R}*s^{4}/U_{m})}

where \eqn{s^{4}} is the saturation value. The formula for Model 4 is:

\deqn{U_{\hat{m}}*s^{4}/U_{m})}

We included all four models to calculate maze ability.
}
\examples{
 nodePosition <- np(rank=6,satPercent=0.5,seed=1)
 mazeAbility(nodePosition,dot=3, model="t2")
}
\author{
Aiden Loe and Maria Sanchez
}
\seealso{
\code{\link{mazeDiff}}, \code{\link{np}}
}

