% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gg_path.R
\name{plot_gg_path}
\alias{plot_gg_path}
\title{Plot shortest path in genealogical tree with \code{ggenealogy}}
\usage{
plot_gg_path(g, id1 = NULL, id2 = NULL, expand = 0.15)
}
\arguments{
\item{g}{an object of class \code{genealogy}, as returned by \code{\link[=get_genealogy]{get_genealogy()}}.}

\item{id1}{an \code{integer(1)} or \code{character(1)} with the ID of the first mathematician of interest.}

\item{id2}{an \code{integer(1)} or \code{character(1)} with the ID of the second mathematician of interest.}

\item{expand}{a \code{numeric(1)} with the expansion factor for the graph.
This defaults to \code{0.15}, with larger values causing the \code{x} axis to expand, smaller values for it to shrink.
This is useful if the nearest common ancestor has a long name, which may cause it to be clipped when plotting: increase this expansion factor to rectify this.}
}
\value{
An object of class \verb{("gg", "ggplot")} which can be displayed, or further manipulated using additional layers or aesthetic modifications from the \code{\link[ggplot2:ggplot2-package]{ggplot2}} package.
}
\description{
Plots a shortest path between two mathematicians in a genealogical tree using the \code{ggenealogy} layout engine.
}
\details{
This function requires the \code{ggenealogy} package to be installed.
It is only a "Suggests" dependency because this package supports multiple plotting approaches.
The presence of this package will be verified when the function is actually called, providing an opportunity to install automatically if needed.

The shortest path between the two mathematician IDs provided is plotted, with the \code{x} position of each label determined by the year of PhD award.

\strong{NOTE:} if the name of the nearest common ancestor is long, it can be clipped by \code{ggplot2}.
If this occurs, increase the \code{expand} argument greater than the default of \code{0.15}.
}
\examples{
# First, you need to use search_id() to find the mathematician ID for the
# individual(s) you wish to plot, or visit https://mathgenealogy.org/ to look
# up in the browser.

# For example, to find the shortest genealogical path between the package
# author and my former postdoc supervisor, I would start by querying using
# both mathematician IDs
g <- get_genealogy(c(96119, 171971))

# Then use the plot_gg_path() function to use the underlying ggenealogy package
plot_gg_path(g)
}
\references{
Rutter, L., VanderPlas, S., Cook, D. and Graham, M.A. (2019). “ggenealogy: An R Package for Visualizing Genealogical Data”, \emph{Journal of Statistical Software}, \strong{89}(13), 1-31. \doi{10.18637/jss.v089.i13}.

Wickham, H. (2016). \emph{ggplot2: Elegant Graphics for Data Analysis}. Springer-Verlag New York.
}
