% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disciplines.R
\name{disciplines}
\alias{disciplines}
\title{Mathematical discipline IDs}
\usage{
disciplines(search = NULL)
}
\arguments{
\item{search}{a character(1) string which will search within disciplines.
This can be a regular expression search term if desired.}
}
\value{
Data frame, with columns:
\describe{
\item{\code{id}}{the discipline ID, as required by \code{\link[=search_id]{search_id()}} when searching for a mathematician within a specific mathematical discipline;}
\item{\code{discipline}}{the name of the discipline classification, per the Mathematics Genealogy Project.}
}
}
\description{
Map mathematical disciplines to IDs for use in searching for mathematicians.
}
\examples{
# Lookup the ID of any discipline involving the partial word "stat"
disciplines("stat")

# Use a regular expression to only exactly match the whole word Statistics and nothing else
disciplines("^statistics$")

# Use the above to search only for statisticians with the first name Louis
search_id(given = "Louis", discipline = disciplines("^statistics$")$id)
}
