% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{galeShapleyMatching}
\alias{galeShapleyMatching}
\title{Compute the Gale-Shapley Algorithm}
\usage{
galeShapleyMatching(proposerPref, reviewerUtils)
}
\arguments{
\item{proposerPref}{is a matrix with the preference order of the proposing side of
the market}

\item{reviewerUtils}{is a matrix with cardinal utilities of the courted side of the
market}
}
\value{
A list with the successful proposals and engagements.
\code{proposals} is a vector whose nth element contains the id of the reviewer
that proposer n is matched to.
\code{engagements} is a vector whose nth element contains the id of the proposer
that reviewer n is matched to.
}
\description{
This function computes the Gale-Shapley Algorithm with one-to-one matching.
This function requires very specific types of arguments. It might be more
convenient to call the function \code{one2one()} instead that allows for
more flexible input choices.
}

