/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.automata.fast_multicostregular;

import choco.kernel.common.util.tools.ArrayUtils;

public class CostWrapper {
    int ressources;
    int size;
    int values;
    int states;
    int[][][] cost3d;
    int[][][][] cost4d;
    FourTuple[] sparse3d;
    FiveTuple[] sparse4d;
    Representation representation;

    public CostWrapper(int[][][] costs) {
        this.representation = Representation.MAT3D;
        this.cost3d = ArrayUtils.swallowCopy(costs);
        this.size = costs.length;
        this.values = costs[0].length;
        this.ressources = costs[0][0].length;
        this.states = 1;
    }

    public CostWrapper(int[][][][] costs) {
        this.representation = Representation.MAT4D;
        this.cost4d = ArrayUtils.swallowCopy(costs);
        this.size = costs.length;
        this.values = costs[0].length;
        this.ressources = costs[0][0].length;
        this.states = costs[0][0][0].length;
    }

    public CostWrapper(int[] i, int[] j, int[] r, int[] q, int[] val) {
        int sz = i.length;
        this.sparse4d = new FiveTuple[sz];
        for (int idx = 0; idx < sz; ++idx) {
            this.sparse4d[idx] = new FiveTuple(i[idx], j[idx], r[idx], q[idx], val[idx]);
        }
    }

    public int get(int i, int j, int r, int q) {
        switch (this.representation) {
            case MAT3D: {
                return this.get3D(i, j, r);
            }
            case MAT4D: {
                return this.get4D(i, j, r, q);
            }
            case SPARSE3D: {
                return this.getS3D(i, j, r);
            }
            case SPARSE4D: {
                return this.getS4D(i, j, r, q);
            }
        }
        return Integer.MIN_VALUE;
    }

    private int getS3D(int i, int j, int r) {
        return 0;
    }

    private int getS4D(int i, int j, int r, int q) {
        return 0;
    }

    private int get4D(int i, int j, int r, int q) {
        return this.cost4d[i][j][r][q];
    }

    private int get3D(int i, int j, int r) {
        return this.cost3d[i][j][r];
    }

    public int ressouces() {
        return this.ressources;
    }

    public int size() {
        return this.size;
    }

    public int values() {
        return this.values;
    }

    public int states() {
        return this.states;
    }

    public boolean isStateDependant() {
        return this.representation != Representation.MAT3D;
    }

    private class FiveTuple
    extends FourTuple {
        int q;

        public FiveTuple(int i, int j, int r, int q, int val) {
            super(i, j, r, val);
            this.q = q;
        }

        public final int q() {
            return this.q;
        }
    }

    private class FourTuple {
        int i;
        int j;
        int r;
        int val;

        public FourTuple(int i, int j, int r, int val) {
            this.i = i;
            this.j = j;
            this.r = r;
            this.val = val;
        }

        public final int i() {
            return this.i;
        }

        public final int j() {
            return this.j;
        }

        public final int r() {
            return this.r;
        }

        public final int val() {
            return this.val;
        }
    }

    static enum Representation {
        MAT3D,
        MAT4D,
        SPARSE3D,
        SPARSE4D;

    }
}

