% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_worldclim.R
\name{worldclim_precipitation}
\alias{worldclim_precipitation}
\alias{get_worldclim_precipitation}
\title{Downloads WorldClim Mean Precipitation layer}
\source{
\url{https://www.worldclim.org/data/index.html}
}
\usage{
get_worldclim_precipitation(years = 2000:2018)
}
\arguments{
\item{years}{A numeric vector indicating for which years to make the
resource available.}
}
\value{
A function that returns an \code{sf} footprint object.
}
\description{
This resource is published by Fick et al. (2017) "WorldClim 2: new 1-km
spatial resolution climate surfaces for global land areas" and
represents multiple climatic variables from which we will be requiring minimum
temperature, maximum temperature, and mean precipitation layers. The layers are
available to download for the period 2000 - 2018 on monthly basis from WorldClim.
}
\details{
This resource represents the average precipitation, layers available to
download for the period 2000 - 2018 on monthly basis from WorldClim. Encoded
as (mm), representing the mean precipitation per output grid cell.
}
\keyword{resource}
